/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.parser;

import de.jplag.AbstractParser;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.emf.MetamodelToken;
import de.jplag.emf.normalization.ModelSorter;
import de.jplag.emf.parser.MetamodelElementTokenizer;
import de.jplag.emf.parser.MetamodelTokenGenerator;
import de.jplag.emf.util.AbstractMetamodelVisitor;
import de.jplag.emf.util.AbstractModelView;
import de.jplag.emf.util.EMFUtil;
import de.jplag.emf.util.EmfaticModelView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class EcoreParser
extends AbstractParser {
    protected List<Token> tokens;
    protected File currentFile;
    protected AbstractModelView treeView;
    protected AbstractMetamodelVisitor visitor;

    public EcoreParser() {
        EMFUtil.registerEcoreExtension();
    }

    public List<Token> parse(Set<File> files, boolean normalize) throws ParsingException {
        this.tokens = new ArrayList<Token>();
        for (File file : files) {
            this.parseModelFile(file, normalize);
        }
        return this.tokens;
    }

    protected void parseModelFile(File file, boolean normalize) throws ParsingException {
        this.currentFile = file;
        Resource model = EMFUtil.loadModelResource(file);
        if (model == null) {
            throw new ParsingException(file, "failed to load model");
        }
        if (normalize) {
            this.normalizeOrder(model);
        }
        this.treeView = this.createView(file, model);
        this.visitor = this.createMetamodelVisitor();
        for (EObject root : model.getContents()) {
            this.visitor.visit(root);
        }
        this.tokens.add(Token.fileEnd((File)this.currentFile));
        this.treeView.writeToFile(this.getCorrespondingViewFileSuffix());
    }

    protected String getCorrespondingViewFileSuffix() {
        return ".emfatic";
    }

    protected AbstractModelView createView(File file, Resource modelResource) throws ParsingException {
        return new EmfaticModelView(file, modelResource);
    }

    protected void normalizeOrder(Resource modelResource) {
        ModelSorter.sort(modelResource, new MetamodelElementTokenizer());
    }

    protected AbstractMetamodelVisitor createMetamodelVisitor() {
        return new MetamodelTokenGenerator(this);
    }

    protected void addToken(TokenType type, EObject source) {
        MetamodelToken token = new MetamodelToken(type, this.currentFile, source);
        this.tokens.add(this.treeView.convertToMetadataEnrichedToken(token));
    }
}

