/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.normalization;

import de.jplag.TokenType;
import de.jplag.emf.normalization.TokenOccurenceVector;
import de.jplag.emf.parser.ModelingElementTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;

public class TokenVectorGenerator {
    private final ModelingElementTokenizer tokenizer;

    public TokenVectorGenerator(ModelingElementTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public TokenOccurenceVector generateOccurenceVector(Iterator<EObject> modelElements) {
        HashMap tokenTypeHistogram = new HashMap();
        while (modelElements.hasNext()) {
            this.tokenizer.element2OptionalToken(modelElements.next()).ifPresent(it -> tokenTypeHistogram.merge(it, 1, Integer::sum));
        }
        ArrayList<Integer> occurenceVector = new ArrayList<Integer>();
        for (TokenType type : this.tokenizer.allTokenTypes()) {
            occurenceVector.add(tokenTypeHistogram.getOrDefault(type, 0));
        }
        return new TokenOccurenceVector(TokenVectorGenerator.normalize(occurenceVector));
    }

    public static List<Double> normalize(List<Integer> vector) {
        double magnitude = Math.sqrt(vector.stream().mapToInt(it -> it * it).sum());
        if (magnitude == 0.0) {
            return Collections.nCopies(vector.size(), 0.0);
        }
        ArrayList<Double> normalizedVector = new ArrayList<Double>();
        for (int element : vector) {
            double normalizedValue = (double)element / magnitude;
            normalizedVector.add(normalizedValue);
        }
        return normalizedVector;
    }
}

