/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.normalization;

import de.jplag.emf.normalization.ContainmentOrderNormalizer;
import de.jplag.emf.parser.ModelingElementTokenizer;
import de.jplag.emf.util.AbstractMetamodelVisitor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;

public class ModelSorter
extends AbstractMetamodelVisitor {
    private final ModelingElementTokenizer tokenizer;

    private ModelSorter(ModelingElementTokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    public static void sort(Resource modelResource, ModelingElementTokenizer tokenizer) {
        modelResource.getContents().forEach(new ModelSorter(tokenizer)::visit);
    }

    @Override
    protected void visitEObject(EObject eObject) {
        for (EReference reference : eObject.eClass().getEAllContainments()) {
            Object containment;
            if (!reference.isMany() || !((containment = eObject.eGet((EStructuralFeature)reference)) instanceof List)) continue;
            List containmentList = (List)containment;
            ArrayList<EObject> sortedContent = new ArrayList<EObject>(containmentList);
            sortedContent.sort(new ContainmentOrderNormalizer(sortedContent, this.tokenizer));
            containmentList.clear();
            containmentList.addAll(sortedContent);
        }
    }
}

