/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.normalization;

import de.jplag.TokenType;
import de.jplag.emf.normalization.TokenOccurenceVector;
import de.jplag.emf.normalization.TokenVectorGenerator;
import de.jplag.emf.parser.ModelingElementTokenizer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

public class ContainmentOrderNormalizer
implements Comparator<EObject> {
    private final List<EObject> modelElementsToSort;
    private final Map<TokenType, List<EObject>> paths;
    private final ModelingElementTokenizer tokenizer;
    private final TokenVectorGenerator tokenVectorGenerator;

    public ContainmentOrderNormalizer(List<EObject> modelElementsToSort, ModelingElementTokenizer tokenizer) {
        this.modelElementsToSort = modelElementsToSort;
        this.tokenizer = tokenizer;
        this.paths = new HashMap<TokenType, List<EObject>>();
        this.tokenVectorGenerator = new TokenVectorGenerator(tokenizer);
    }

    @Override
    public int compare(EObject first, EObject second) {
        TokenType firstType = this.tokenizer.element2Token(first);
        TokenType secondType = this.tokenizer.element2Token(second);
        if (firstType == null && secondType == null) {
            return 0;
        }
        if (firstType == null) {
            return -1;
        }
        if (secondType == null) {
            return 1;
        }
        int comparisonByType = firstType.toString().compareTo(secondType.toString());
        if (comparisonByType != 0) {
            return comparisonByType;
        }
        List path = this.paths.computeIfAbsent(firstType, this::calculatePath);
        return path.indexOf(first) - path.indexOf(second);
    }

    private List<EObject> calculatePath(List<EObject> elements, EObject start, double[][] distances) {
        ArrayList<EObject> path = new ArrayList<EObject>();
        HashSet<EObject> remaining = new HashSet<EObject>(elements);
        EObject current = start;
        remaining.remove(current);
        path.add(current);
        while (!remaining.isEmpty()) {
            double shortestDistance = Double.MAX_VALUE;
            EObject next = null;
            for (EObject potentialNext : remaining) {
                double distance = distances[elements.indexOf(current)][elements.indexOf(potentialNext)];
                if (distance < shortestDistance) {
                    shortestDistance = distance;
                    next = potentialNext;
                    continue;
                }
                if (distance != shortestDistance || this.modelElementsToSort.indexOf(potentialNext) >= this.modelElementsToSort.indexOf(next)) continue;
                next = potentialNext;
            }
            current = next;
            remaining.remove(current);
            path.add(current);
        }
        return path;
    }

    private List<EObject> calculatePath(TokenType type) {
        List<EObject> elements = this.modelElementsToSort.stream().filter(it -> type.equals((Object)this.tokenizer.element2Token((EObject)it))).toList();
        HashMap subtreeVectors = new HashMap();
        elements.forEach(it -> subtreeVectors.put(it, this.tokenVectorGenerator.generateOccurenceVector((Iterator<EObject>)it.eAllContents())));
        double[][] distances = new double[elements.size()][elements.size()];
        for (int from = 0; from < distances.length; ++from) {
            for (int to = 0; to < distances.length; ++to) {
                distances[from][to] = ContainmentOrderNormalizer.euclideanDistance((TokenOccurenceVector)subtreeVectors.get(elements.get(from)), (TokenOccurenceVector)subtreeVectors.get(elements.get(to)));
            }
        }
        EObject max = Collections.max(elements, (first, second) -> Integer.compare(this.countSubtreeTokens((EObject)first), this.countSubtreeTokens((EObject)second)));
        return this.calculatePath(elements, max, distances);
    }

    private int countSubtreeTokens(EObject modelElement) {
        int count = 0;
        TreeIterator iterator = modelElement.eAllContents();
        while (iterator.hasNext()) {
            if (this.tokenizer.element2Token((EObject)iterator.next()) == null) continue;
            ++count;
        }
        return count;
    }

    private static double euclideanDistance(TokenOccurenceVector first, TokenOccurenceVector second) {
        double sum = 0.0;
        for (int i = 0; i < first.size(); ++i) {
            double diff = first.get(i) - second.get(i);
            sum += diff * diff;
        }
        return Math.sqrt(sum);
    }
}

