/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf;

import de.jplag.TokenType;

public enum MetamodelTokenType implements TokenType
{
    PACKAGE("EPackage"),
    PACKAGE_END(PACKAGE),
    ANNOTATION("EAnnotation"),
    CLASS("EClass"),
    CLASS_END(CLASS),
    DATATYPE("EDatatype"),
    ENUM("EEnum"),
    ENUM_END(ENUM),
    ENUM_LITERAL("EEnumLiteral"),
    OPERATION("EOperation"),
    REFERENCE("EReference"),
    REFERENCE_MULT("EReference (multi-valued)"),
    ATTRIBUTE("EAttribute"),
    PARAMETER("EParameter"),
    INTERFACE("EInterface"),
    INTERFACE_END(INTERFACE),
    ID_ATTRIBUTE("EAttribute (ID)"),
    CONTAINMENT("EReference (Containment)"),
    CONTAINMENT_MULT("EReference (Containment, multi-valued)"),
    ABSTRACT_CLASS("EAbstractClass"),
    ABSTRACT_CLASS_END(ABSTRACT_CLASS),
    RETURN_TYPE("EClassifier (Return Type"),
    THROWS_DECLARATION("EException"),
    TYPE_PARAMETER("Type Parameter"),
    BOUND("Bound");

    private static final String END_TOKEN_SUFFIX = " (End)";
    private final String description;
    private final boolean isEndToken;

    public String getDescription() {
        return this.description;
    }

    private MetamodelTokenType(String description) {
        this.description = description;
        this.isEndToken = false;
    }

    private MetamodelTokenType(MetamodelTokenType beginType) {
        this.description = beginType.getDescription() + END_TOKEN_SUFFIX;
        this.isEndToken = true;
    }

    public boolean isEndToken() {
        return this.isEndToken;
    }
}

