/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.util;

import de.jplag.emf.AbstractEmfTest;
import de.jplag.emf.util.GenericEmfTreeView;
import de.jplag.testutils.FileUtil;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class GenericEmfTreeViewTest
extends AbstractEmfTest {
    private static final String VIEW_FILE_SUFFIX = ".treeview";
    private static final String EXPECTED_VIEW_FOLDER = "treeview";

    GenericEmfTreeViewTest() {
    }

    private static List<String> provideModelNames() {
        return Arrays.asList(TEST_SUBJECTS);
    }

    @ParameterizedTest
    @DisplayName(value="Test content of generic EMF view files of example metamodels")
    @MethodSource(value={"provideModelNames"})
    void testEmfaticViewFiles(String modelName) {
        File modelFile = new File(this.baseDirectory, modelName);
        Resource modelResource = this.loadAndVerifyModel(modelFile);
        GenericEmfTreeView view = new GenericEmfTreeView(modelFile, modelResource);
        view.writeToFile(VIEW_FILE_SUFFIX);
        this.assertViewFilesMatch(modelFile, VIEW_FILE_SUFFIX, EXPECTED_VIEW_FOLDER);
    }

    @Override
    @AfterEach
    protected void tearDown() {
        FileUtil.clearFiles((File)new File(BASE_PATH.toString()), (String)VIEW_FILE_SUFFIX);
    }
}

