/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.util;

import de.jplag.ParsingException;
import de.jplag.emf.AbstractEmfTest;
import de.jplag.emf.util.EmfaticModelView;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class EmfaticModelViewTest
extends AbstractEmfTest {
    private static final String EXPECTED_VIEW_FOLDER = "emfatic";

    EmfaticModelViewTest() {
    }

    private static List<String> provideModelNames() {
        return Arrays.asList(TEST_SUBJECTS);
    }

    @ParameterizedTest
    @DisplayName(value="Test content of emfatic view files of example metamodels")
    @MethodSource(value={"provideModelNames"})
    void testEmfaticViewFiles(String modelName) throws ParsingException {
        File modelFile = new File(this.baseDirectory, modelName);
        Resource modelResource = this.loadAndVerifyModel(modelFile);
        EmfaticModelView view = new EmfaticModelView(modelFile, modelResource);
        view.writeToFile(".emfatic");
        this.assertViewFilesMatch(modelFile, ".emfatic", EXPECTED_VIEW_FOLDER);
    }
}

