/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf;

import de.jplag.Language;
import de.jplag.emf.EmfLanguage;
import de.jplag.emf.util.EMFUtil;
import de.jplag.testutils.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public abstract class AbstractEmfTest {
    protected static final Path BASE_PATH = Path.of("src", "test", "resources", "de", "jplag", "emf");
    protected static final String[] TEST_SUBJECTS = new String[]{"bookStore.ecore", "bookStoreExtended.ecore", "bookStoreExtendedRefactor.ecore", "bookStoreRenamed.ecore"};
    protected Language language;
    protected File baseDirectory;

    @BeforeEach
    protected void setUp() {
        this.language = new EmfLanguage();
        this.baseDirectory = BASE_PATH.toFile();
        FileUtil.assertDirectory((File)this.baseDirectory, (String[])TEST_SUBJECTS);
    }

    @AfterEach
    protected void tearDown() {
        FileUtil.clearFiles((File)new File(BASE_PATH.toString()), (String)".emfatic");
    }

    protected Resource loadAndVerifyModel(File modelFile) {
        Assertions.assertTrue((boolean)modelFile.exists());
        Resource modelResource = EMFUtil.loadModelResource((File)modelFile);
        Assertions.assertNotNull((Object)modelResource);
        return modelResource;
    }

    protected void assertViewFilesMatch(File modelFile, String viewFileSuffix, String directoryOfExpectedViews) {
        File viewFile = new File(modelFile.getPath() + viewFileSuffix);
        File expectedViewFile = BASE_PATH.resolveSibling(Path.of(directoryOfExpectedViews, viewFile.getName())).toFile();
        Assertions.assertTrue((boolean)viewFile.exists());
        Assertions.assertTrue((boolean)expectedViewFile.exists());
        try {
            Assertions.assertLinesMatch(Files.readAllLines(expectedViewFile.toPath()), Files.readAllLines(viewFile.toPath()));
        }
        catch (IOException exception) {
            Assertions.fail((Throwable)exception);
        }
    }
}

