/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf;

import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenPrinter;
import de.jplag.TokenType;
import de.jplag.emf.AbstractEmfTest;
import de.jplag.testutils.TokenUtils;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinimalMetamodelTest
extends AbstractEmfTest {
    private final Logger logger = LoggerFactory.getLogger(MinimalMetamodelTest.class);

    MinimalMetamodelTest() {
    }

    @Test
    @DisplayName(value="Test tokens generated from example metamodels")
    void testBookstoreMetamodels() throws ParsingException {
        List<File> testFiles = Arrays.stream(TEST_SUBJECTS).map(path -> new File(BASE_PATH.toFile(), (String)path)).toList();
        List result = this.language.parse(new HashSet<File>(testFiles));
        this.logger.debug(TokenPrinter.printTokens((List)result, (File)this.baseDirectory, Optional.of(".emfatic")));
        List<TokenType> tokenTypes = result.stream().map(Token::getType).toList();
        this.logger.info("Parsed token types: " + tokenTypes.stream().map(TokenType::getDescription).toList().toString());
        Assertions.assertEquals((int)82, (int)tokenTypes.size());
        Assertions.assertEquals((int)13, (int)new HashSet<TokenType>(tokenTypes).size());
        List originalTokens = TokenUtils.tokenTypesByFile((List)result, (File)testFiles.get(0));
        List renamedTokens = TokenUtils.tokenTypesByFile((List)result, (File)testFiles.get(3));
        List extendedTokens = TokenUtils.tokenTypesByFile((List)result, (File)testFiles.get(1));
        List renamedRefactorTokens = TokenUtils.tokenTypesByFile((List)result, (File)testFiles.get(2));
        Assertions.assertTrue((originalTokens.size() < extendedTokens.size() ? 1 : 0) != 0);
        Assertions.assertTrue((renamedTokens.size() < renamedRefactorTokens.size() ? 1 : 0) != 0);
        Assertions.assertIterableEquals((Iterable)originalTokens, (Iterable)renamedTokens);
    }
}

