/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf.util;

import de.jplag.emf.AbstractEmfTest;
import de.jplag.emf.util.EMFUtil;
import de.jplag.emf.util.EmfaticModelView;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.resource.Resource;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class EmfaticModelViewTest
extends AbstractEmfTest {
    private static final String EXPECTED_VIEW_FOLDER = "emfatic";

    EmfaticModelViewTest() {
    }

    private static List<String> provideModelNames() {
        return Arrays.asList(TEST_SUBJECTS);
    }

    @ParameterizedTest
    @DisplayName(value="Test content of emfatic view files of example metamodels")
    @MethodSource(value={"provideModelNames"})
    void testEmfaticViewFiles(String modelName) {
        File modelFile = new File(this.baseDirectory, modelName);
        Assertions.assertTrue((boolean)modelFile.exists());
        Resource modelResource = EMFUtil.loadModelResource((File)modelFile);
        Assertions.assertNotNull((Object)modelResource);
        EmfaticModelView view = new EmfaticModelView(modelFile, modelResource);
        view.writeToFile(".emfatic");
        File viewFile = new File(modelFile.getPath() + ".emfatic");
        Assertions.assertTrue((boolean)viewFile.exists());
        File expectedViewFile = BASE_PATH.resolveSibling(Path.of(EXPECTED_VIEW_FOLDER, viewFile.getName())).toFile();
        Assertions.assertTrue((boolean)expectedViewFile.exists());
        try {
            Assertions.assertEquals((Object)Files.readString(expectedViewFile.toPath()), (Object)Files.readString(viewFile.toPath()));
        }
        catch (IOException exception) {
            Assertions.fail((Throwable)exception);
        }
    }
}

