/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.emf;

import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenPrinter;
import de.jplag.TokenType;
import de.jplag.emf.Language;
import de.jplag.testutils.FileUtil;
import de.jplag.testutils.TokenUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinimalMetamodelTest {
    private final Logger logger = LoggerFactory.getLogger(MinimalMetamodelTest.class);
    private static final Path BASE_PATH = Path.of("src", "test", "resources", "de", "jplag", "models");
    private static final String[] TEST_SUBJECTS = new String[]{"bookStore.ecore", "bookStoreExtended.ecore", "bookStoreRenamed.ecore"};
    private de.jplag.Language language;
    private File baseDirectory;

    MinimalMetamodelTest() {
    }

    @BeforeEach
    public void setUp() {
        this.language = new Language();
        this.baseDirectory = BASE_PATH.toFile();
        FileUtil.assertDirectory((File)this.baseDirectory, (String[])TEST_SUBJECTS);
    }

    @Test
    void testBookstoreMetamodels() throws ParsingException {
        List<File> testFiles = Arrays.stream(TEST_SUBJECTS).map(path -> new File(BASE_PATH.toFile(), (String)path)).toList();
        List result = this.language.parse(new HashSet<File>(testFiles));
        this.logger.debug(TokenPrinter.printTokens((List)result, (File)this.baseDirectory, Optional.of(".TreeView")));
        List<TokenType> tokenTypes = result.stream().map(Token::getType).toList();
        this.logger.info("Parsed token types: " + tokenTypes.stream().map(TokenType::getDescription).toList().toString());
        Assertions.assertEquals((int)43, (int)tokenTypes.size());
        Assertions.assertEquals((int)10, (int)new HashSet<TokenType>(tokenTypes).size());
        List bookstoreTokens = TokenUtils.tokenTypesByFile((List)result, (File)testFiles.get(0));
        List bookstoreRenamedTokens = TokenUtils.tokenTypesByFile((List)result, (File)testFiles.get(2));
        List bookstoreExtendedTokens = TokenUtils.tokenTypesByFile((List)result, (File)testFiles.get(1));
        Assertions.assertTrue((bookstoreTokens.size() < bookstoreExtendedTokens.size() ? 1 : 0) != 0);
        Assertions.assertIterableEquals((Iterable)bookstoreTokens, (Iterable)bookstoreRenamedTokens);
    }

    @AfterEach
    public void tearDown() {
        FileUtil.clearFiles((File)new File(BASE_PATH.toString()), (String)".TreeView");
    }
}

