/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.csharp;

import de.jplag.ParsingException;
import de.jplag.SharedTokenType;
import de.jplag.Token;
import de.jplag.TokenPrinter;
import de.jplag.TokenType;
import de.jplag.csharp.CSharpTokenType;
import de.jplag.csharp.Language;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MinimalCSharpTest {
    private final Logger logger = LoggerFactory.getLogger(MinimalCSharpTest.class);
    private static final Path BASE_PATH = Path.of("src", "test", "resources", "de", "jplag", "csharp");
    private static final String TEST_SUBJECT = "TestClass.cs";
    private de.jplag.Language language;
    private File baseDirectory;

    MinimalCSharpTest() {
    }

    @BeforeEach
    public void setUp() {
        this.language = new Language();
        this.baseDirectory = BASE_PATH.toFile();
        Assertions.assertTrue((boolean)this.baseDirectory.exists(), (String)"Could not find base directory!");
    }

    @Test
    void testParsingTestClass() throws ParsingException {
        List<TokenType> expectedToken = List.of(CSharpTokenType.CLASS, CSharpTokenType.CLASS_BEGIN, CSharpTokenType.FIELD, CSharpTokenType.CONSTRUCTOR, CSharpTokenType.LOCAL_VARIABLE, CSharpTokenType.METHOD, CSharpTokenType.METHOD_BEGIN, CSharpTokenType.IF, CSharpTokenType.IF_BEGIN, CSharpTokenType.INVOCATION, CSharpTokenType.IF_END, CSharpTokenType.IF_BEGIN, CSharpTokenType.INVOCATION, CSharpTokenType.IF_END, CSharpTokenType.METHOD_END, CSharpTokenType.PROPERTY, CSharpTokenType.ACCESSORS_BEGIN, CSharpTokenType.ACCESSOR_BEGIN, CSharpTokenType.ACCESSOR_END, CSharpTokenType.ACCESSOR_BEGIN, CSharpTokenType.ACCESSOR_END, CSharpTokenType.ACCESSORS_END, CSharpTokenType.FIELD, CSharpTokenType.PROPERTY, CSharpTokenType.ACCESSORS_BEGIN, CSharpTokenType.ACCESSOR_BEGIN, CSharpTokenType.RETURN, CSharpTokenType.ACCESSOR_END, CSharpTokenType.ACCESSOR_BEGIN, CSharpTokenType.ASSIGNMENT, CSharpTokenType.ACCESSOR_END, CSharpTokenType.ACCESSORS_END, CSharpTokenType.CLASS_END, SharedTokenType.FILE_END);
        List result = this.language.parse(Set.of(new File(this.baseDirectory, TEST_SUBJECT)));
        this.logger.info(TokenPrinter.printTokens((List)result, (File)this.baseDirectory));
        Assertions.assertEquals((int)expectedToken.size(), (int)result.size());
        List<TokenType> actualToken = result.stream().map(Token::getType).toList();
        Assertions.assertEquals(expectedToken, actualToken);
    }
}

