/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.csharp.grammar;

import de.jplag.csharp.grammar.CSharpPreprocessorParser;
import java.util.HashSet;
import java.util.Objects;
import java.util.Stack;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.TokenStream;

abstract class CSharpPreprocessorParserBase
extends Parser {
    private static final String FALSE = Boolean.toString(false);
    private static final String TRUE = Boolean.toString(true);
    private static final String DEBUG = "DEBUG";
    private final Stack<Boolean> conditions = new Stack();
    private final HashSet<String> conditionalSymbols = new HashSet();

    protected CSharpPreprocessorParserBase(TokenStream input) {
        super(input);
        this.conditions.push(true);
        this.conditionalSymbols.add(DEBUG);
    }

    protected Boolean allConditions() {
        return this.conditions.stream().allMatch(it -> it);
    }

    protected void onPreprocessorDirectiveDefine() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorDeclarationContext context = (CSharpPreprocessorParser.PreprocessorDeclarationContext)ruleContext;
        this.conditionalSymbols.add(context.CONDITIONAL_SYMBOL().getText());
        context.value = this.allConditions();
    }

    protected void onPreprocessorDirectiveUndef() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorDeclarationContext context = (CSharpPreprocessorParser.PreprocessorDeclarationContext)ruleContext;
        this.conditionalSymbols.remove(context.CONDITIONAL_SYMBOL().getText());
        context.value = this.allConditions();
    }

    protected void onPreprocessorDirectiveIf() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorConditionalContext context = (CSharpPreprocessorParser.PreprocessorConditionalContext)ruleContext;
        context.value = context.expr.value.equals(TRUE) && this.allConditions() != false;
        this.conditions.push(context.expr.value.equals(TRUE));
    }

    protected void onPreprocessorDirectiveElif() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorConditionalContext context = (CSharpPreprocessorParser.PreprocessorConditionalContext)ruleContext;
        if (Boolean.FALSE.equals(this.conditions.peek())) {
            this.conditions.pop();
            context.value = context.expr.value.equals(TRUE) && this.allConditions() != false;
            this.conditions.push(context.expr.value.equals(TRUE));
        } else {
            context.value = false;
        }
    }

    protected void onPreprocessorDirectiveElse() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorConditionalContext context = (CSharpPreprocessorParser.PreprocessorConditionalContext)ruleContext;
        if (Boolean.FALSE.equals(this.conditions.peek())) {
            this.conditions.pop();
            context.value = this.allConditions();
            this.conditions.push(true);
        } else {
            context.value = false;
        }
    }

    protected void onPreprocessorDirectiveEndif() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorConditionalContext context = (CSharpPreprocessorParser.PreprocessorConditionalContext)ruleContext;
        this.conditions.pop();
        context.value = this.conditions.peek();
    }

    protected void onPreprocessorDirectiveLine() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorLineContext context = (CSharpPreprocessorParser.PreprocessorLineContext)ruleContext;
        context.value = this.allConditions();
    }

    protected void onPreprocessorDirectiveError() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorDiagnosticContext context = (CSharpPreprocessorParser.PreprocessorDiagnosticContext)ruleContext;
        context.value = this.allConditions();
    }

    protected void onPreprocessorDirectiveWarning() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorDiagnosticContext context = (CSharpPreprocessorParser.PreprocessorDiagnosticContext)ruleContext;
        context.value = this.allConditions();
    }

    protected void onPreprocessorDirectiveRegion() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorRegionContext context = (CSharpPreprocessorParser.PreprocessorRegionContext)ruleContext;
        context.value = this.allConditions();
    }

    protected void onPreprocessorDirectiveEndregion() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorRegionContext context = (CSharpPreprocessorParser.PreprocessorRegionContext)ruleContext;
        context.value = this.allConditions();
    }

    protected void onPreprocessorDirectivePragma() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorPragmaContext context = (CSharpPreprocessorParser.PreprocessorPragmaContext)ruleContext;
        context.value = this.allConditions();
    }

    protected void onPreprocessorDirectiveNullable() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.PreprocessorNullableContext context = (CSharpPreprocessorParser.PreprocessorNullableContext)ruleContext;
        context.value = this.allConditions();
    }

    protected void onPreprocessorExpressionTrue() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.Preprocessor_expressionContext context = (CSharpPreprocessorParser.Preprocessor_expressionContext)ruleContext;
        context.value = TRUE;
    }

    protected void onPreprocessorExpressionFalse() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.Preprocessor_expressionContext context = (CSharpPreprocessorParser.Preprocessor_expressionContext)ruleContext;
        context.value = FALSE;
    }

    protected void onPreprocessorExpressionConditionalSymbol() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.Preprocessor_expressionContext context = (CSharpPreprocessorParser.Preprocessor_expressionContext)ruleContext;
        String string = this.conditionalSymbols.contains(context.CONDITIONAL_SYMBOL().getText()) ? TRUE : FALSE;
        context.value = string;
    }

    protected void onPreprocessorExpressionConditionalOpenParens() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.Preprocessor_expressionContext context = (CSharpPreprocessorParser.Preprocessor_expressionContext)ruleContext;
        context.value = context.expr.value;
    }

    protected void onPreprocessorExpressionConditionalBang() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.Preprocessor_expressionContext context = (CSharpPreprocessorParser.Preprocessor_expressionContext)ruleContext;
        context.value = context.expr.value.equals(TRUE) ? FALSE : TRUE;
    }

    protected void onPreprocessorExpressionConditionalEq() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.Preprocessor_expressionContext context = (CSharpPreprocessorParser.Preprocessor_expressionContext)ruleContext;
        context.value = Objects.equals(context.expr1.value, context.expr2.value) ? TRUE : FALSE;
    }

    protected void onPreprocessorExpressionConditionalNe() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.Preprocessor_expressionContext context = (CSharpPreprocessorParser.Preprocessor_expressionContext)ruleContext;
        context.value = !Objects.equals(context.expr1.value, context.expr2.value) ? TRUE : FALSE;
    }

    protected void onPreprocessorExpressionConditionalAnd() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.Preprocessor_expressionContext context = (CSharpPreprocessorParser.Preprocessor_expressionContext)ruleContext;
        context.value = context.expr1.value.equals(TRUE) && context.expr2.value.equals(TRUE) ? TRUE : FALSE;
    }

    protected void onPreprocessorExpressionConditionalOr() {
        ParserRuleContext ruleContext = this._ctx;
        CSharpPreprocessorParser.Preprocessor_expressionContext context = (CSharpPreprocessorParser.Preprocessor_expressionContext)ruleContext;
        context.value = context.expr1.value.equals(TRUE) || context.expr2.value.equals(TRUE) ? TRUE : FALSE;
    }
}

