/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.csharp.grammar;

import java.util.Stack;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.Lexer;

abstract class CSharpLexerBase
extends Lexer {
    protected int interpolatedStringLevel;
    protected Stack<Boolean> interpolatedVerbatiums = new Stack();
    protected Stack<Integer> curlyLevels = new Stack();
    protected boolean verbatium;

    protected CSharpLexerBase(CharStream input) {
        super(input);
    }

    protected void onInterpolatedRegularStringStart() {
        ++this.interpolatedStringLevel;
        this.interpolatedVerbatiums.push(false);
        this.verbatium = false;
    }

    protected void onInterpolatedVerbatiumStringStart() {
        ++this.interpolatedStringLevel;
        this.interpolatedVerbatiums.push(true);
        this.verbatium = true;
    }

    protected void onOpenBrace() {
        if (this.interpolatedStringLevel > 0) {
            this.curlyLevels.push(this.curlyLevels.pop() + 1);
        }
    }

    protected void onCloseBrace() {
        if (this.interpolatedStringLevel > 0) {
            this.curlyLevels.push(this.curlyLevels.pop() - 1);
            if (this.curlyLevels.peek() == 0) {
                this.curlyLevels.pop();
                this.skip();
                this.popMode();
            }
        }
    }

    protected void onColon() {
        if (this.interpolatedStringLevel > 0) {
            int ind = 1;
            boolean switchToFormatString = true;
            while ((char)this._input.LA(ind) != '}') {
                if (this._input.LA(ind) == 58 || this._input.LA(ind) == 41) {
                    switchToFormatString = false;
                    break;
                }
                ++ind;
            }
            if (switchToFormatString) {
                this.mode(2);
            }
        }
    }

    protected void openBraceInside() {
        this.curlyLevels.push(1);
    }

    protected void onDoubleQuoteInside() {
        --this.interpolatedStringLevel;
        this.interpolatedVerbatiums.pop();
        this.verbatium = this.interpolatedVerbatiums.size() > 0 ? this.interpolatedVerbatiums.peek() : false;
    }

    protected void onCloseBraceInside() {
        this.curlyLevels.pop();
    }

    protected boolean isRegularCharInside() {
        return !this.verbatium;
    }

    protected boolean isVerbatiumDoubleQuoteInside() {
        return this.verbatium;
    }
}

