/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.cpp;

import de.jplag.Language;
import de.jplag.TokenType;
import de.jplag.cpp.CPPLanguage;
import de.jplag.cpp.CPPTokenType;
import de.jplag.testutils.LanguageModuleTest;
import de.jplag.testutils.datacollector.TestDataCollector;
import de.jplag.testutils.datacollector.TestSourceIgnoredLinesCollector;
import java.util.Arrays;

public class CppLanguageTest
extends LanguageModuleTest {
    private static final String[] assignSnippets = new String[]{"i = 10", "i += 10", "i -= 10", "i += 10", "i /= 10", "i %= 10", "i >>= 10", "i <<= 10", "i &= 10", "i ^= 10", "i |= 10", "i++", "i--", "++i", "--i"};
    private static final String[] functionCallSnippets = new String[]{"this->myMethod(v)", "MyClass::myMethod(v)", "myMethod(v)", "m.myMethod(v)", "myMethod(1)", "myMethod(\"a\")"};
    private static final String intMethodCallFormatter = "void f(int i) {\n    %s;\n}\n";
    private static final String stringMethodCallFormatter = "void a(string v) {\n  %s;\n}\n";

    public CppLanguageTest() {
        super((Language)new CPPLanguage(), CPPTokenType.class);
    }

    protected void collectTestData(TestDataCollector collector) {
        collector.inlineSource(this.formattedCode(intMethodCallFormatter, assignSnippets)).testContainedTokens(new TokenType[]{CPPTokenType.ASSIGN}).testSourceCoverage();
        collector.testFile(new String[]{"FunctionCall.cpp"}).testTokenSequence(new TokenType[]{CPPTokenType.FUNCTION_BEGIN, CPPTokenType.APPLY, CPPTokenType.APPLY, CPPTokenType.APPLY, CPPTokenType.APPLY, CPPTokenType.FUNCTION_END}).testSourceCoverage();
        collector.testFile(new String[]{"Loop.cpp"}).testTokenSequence(new TokenType[]{CPPTokenType.FUNCTION_BEGIN, CPPTokenType.DO_BEGIN, CPPTokenType.GOTO, CPPTokenType.DO_END, CPPTokenType.WHILE_BEGIN, CPPTokenType.BREAK, CPPTokenType.WHILE_END, CPPTokenType.FOR_BEGIN, CPPTokenType.CONTINUE, CPPTokenType.FOR_END, CPPTokenType.RETURN, CPPTokenType.FUNCTION_END}).testSourceCoverage();
        collector.inlineSource(this.formattedCode(stringMethodCallFormatter, functionCallSnippets)).testTokenSequence(new TokenType[]{CPPTokenType.FUNCTION_BEGIN, CPPTokenType.VARDEF, CPPTokenType.APPLY, CPPTokenType.FUNCTION_END}).testSourceCoverage();
        collector.testFile(new String[]{"IfElse.cpp"}).testTokenSequence(new TokenType[]{CPPTokenType.FUNCTION_BEGIN, CPPTokenType.VARDEF, CPPTokenType.VARDEF, CPPTokenType.VARDEF, CPPTokenType.VARDEF, CPPTokenType.IF_BEGIN, CPPTokenType.ASSIGN, CPPTokenType.ELSE, CPPTokenType.IF_BEGIN, CPPTokenType.ASSIGN, CPPTokenType.ASSIGN, CPPTokenType.ELSE, CPPTokenType.ASSIGN, CPPTokenType.IF_END, CPPTokenType.IF_END, CPPTokenType.FUNCTION_END}).testSourceCoverage();
        collector.inlineSource(new String[]{"double* b = new double[10];"}).testTokenSequence(new TokenType[]{CPPTokenType.VARDEF, CPPTokenType.ASSIGN, CPPTokenType.NEWARRAY});
        collector.inlineSource(new String[]{"int x = square(2);"}).testTokenSequence(new TokenType[]{CPPTokenType.VARDEF, CPPTokenType.ASSIGN, CPPTokenType.APPLY});
        collector.testFile(new String[]{"CallOutsideMethodInClass.cpp"}).testTokenSequence(new TokenType[]{CPPTokenType.CLASS_BEGIN, CPPTokenType.VARDEF, CPPTokenType.ASSIGN, CPPTokenType.APPLY, CPPTokenType.CLASS_END});
        collector.testFile(new String[]{"Union.cpp"}).testTokenSequence(new TokenType[]{CPPTokenType.UNION_BEGIN, CPPTokenType.VARDEF, CPPTokenType.VARDEF, CPPTokenType.VARDEF, CPPTokenType.UNION_END}).testSourceCoverage();
        collector.testFile(new String[]{"IntArray.cpp"}).testTokenSequence(new TokenType[]{CPPTokenType.VARDEF, CPPTokenType.ASSIGN, CPPTokenType.BRACED_INIT_BEGIN, CPPTokenType.BRACED_INIT_END, CPPTokenType.VARDEF, CPPTokenType.BRACED_INIT_BEGIN, CPPTokenType.BRACED_INIT_END});
        collector.testFile(new String[]{"bc6h_enc.h"}).testCoverages();
        collector.inlineSource(new String[]{"void test() {\nif(true) {\n    if(false) {\n    } else {\n    }\n} else {\n}\n}\n"});
    }

    protected void configureIgnoredLines(TestSourceIgnoredLinesCollector collector) {
        collector.ignoreByCondition(line -> line.matches(" *[a-zA-Z]+: *"));
        collector.ignoreByCondition(line -> line.matches(" *\\{*"));
        collector.ignoreLinesByPrefix("}");
        collector.ignoreLinesByPrefix("//");
        collector.ignoreLinesByPrefix("#");
        collector.ignoreLinesByPrefix("namespace");
        collector.ignoreLinesByPrefix("using");
        collector.ignoreMultipleLines("/*", "*/");
        collector.ignoreLinesByContains("else");
    }

    private String[] formattedCode(String formatter, String ... snippets) {
        return (String[])Arrays.stream(snippets).map(xva$0 -> formatter.formatted(xva$0)).toArray(String[]::new);
    }
}

