/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.cpp;

import de.jplag.TokenType;
import de.jplag.antlr.AbstractAntlrListener;
import de.jplag.antlr.ContextVisitor;
import de.jplag.cpp.CPPTokenType;
import de.jplag.cpp.grammar.CPP14Parser;
import de.jplag.semantics.CodeSemantics;
import de.jplag.semantics.VariableAccessType;
import de.jplag.semantics.VariableRegistry;
import de.jplag.semantics.VariableScope;
import java.util.function.Function;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.TerminalNode;

class CPPListener
extends AbstractAntlrListener {
    CPPListener() {
        this.visit(CPP14Parser.ClassSpecifierContext.class, rule -> rule.classHead().Union() != null).map((TokenType)CPPTokenType.UNION_BEGIN, (TokenType)CPPTokenType.UNION_END).addClassScope().withSemantics(CodeSemantics::createControl);
        this.mapClass(CPP14Parser.ClassKeyContext::Class, CPPTokenType.CLASS_BEGIN, CPPTokenType.CLASS_END);
        this.mapClass(CPP14Parser.ClassKeyContext::Struct, CPPTokenType.STRUCT_BEGIN, CPPTokenType.STRUCT_END);
        this.visit(CPP14Parser.EnumSpecifierContext.class).map((TokenType)CPPTokenType.ENUM_BEGIN, (TokenType)CPPTokenType.ENUM_END).addClassScope().withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.FunctionDefinitionContext.class).map((TokenType)CPPTokenType.FUNCTION_BEGIN, (TokenType)CPPTokenType.FUNCTION_END).addLocalScope().withSemantics(CodeSemantics::createControl);
        this.statementRules();
        this.visit(CPP14Parser.TryBlockContext.class).map((TokenType)CPPTokenType.TRY_BEGIN, (TokenType)CPPTokenType.TRY_END).addLocalScope().withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.HandlerContext.class).map((TokenType)CPPTokenType.CATCH_BEGIN, (TokenType)CPPTokenType.CATCH_END).addLocalScope().withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.ThrowExpressionContext.class).map((TokenType)CPPTokenType.THROW).withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.NewExpressionContext.class, rule -> rule.newInitializer() != null).map((TokenType)CPPTokenType.NEWCLASS).withSemantics(CodeSemantics::new);
        this.visit(CPP14Parser.NewExpressionContext.class, rule -> rule.newInitializer() == null).map((TokenType)CPPTokenType.NEWARRAY).withSemantics(CodeSemantics::new);
        this.visit(CPP14Parser.TemplateDeclarationContext.class).map((TokenType)CPPTokenType.GENERIC).withSemantics(CodeSemantics::new);
        this.visit(CPP14Parser.AssignmentOperatorContext.class).map((TokenType)CPPTokenType.ASSIGN).withSemantics(CodeSemantics::new).onEnter((rule, varReg) -> varReg.setNextVariableAccessType(VariableAccessType.WRITE));
        this.visit(CPP14Parser.UnaryExpressionContext.class, rule -> rule.PlusPlus() != null || rule.MinusMinus() != null).map((TokenType)CPPTokenType.ASSIGN).withSemantics(CodeSemantics::new).onEnter((rule, varReg) -> varReg.setNextVariableAccessType(VariableAccessType.READ_WRITE));
        this.visit(CPP14Parser.StaticAssertDeclarationContext.class).map((TokenType)CPPTokenType.STATIC_ASSERT).withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.EnumeratorDefinitionContext.class).map((TokenType)CPPTokenType.VARDEF).withSemantics(CodeSemantics::new).onEnter((rule, varReg) -> varReg.setNextVariableAccessType(VariableAccessType.WRITE));
        this.visit(CPP14Parser.BracedInitListContext.class).map((TokenType)CPPTokenType.BRACED_INIT_BEGIN, (TokenType)CPPTokenType.BRACED_INIT_END).withSemantics(CodeSemantics::new);
        this.typeSpecifierRule();
        this.declarationRules();
        this.expressionRules();
        this.idRules();
    }

    private void statementRules() {
        this.visit(CPP14Parser.IterationStatementContext.class, rule -> rule.Do() != null).map((TokenType)CPPTokenType.DO_BEGIN, (TokenType)CPPTokenType.DO_END).addLocalScope().withLoopSemantics();
        this.visit(CPP14Parser.IterationStatementContext.class, rule -> rule.For() != null).map((TokenType)CPPTokenType.FOR_BEGIN, (TokenType)CPPTokenType.FOR_END).addLocalScope().withLoopSemantics();
        this.visit(CPP14Parser.IterationStatementContext.class, rule -> rule.While() != null && rule.Do() == null).map((TokenType)CPPTokenType.WHILE_BEGIN, (TokenType)CPPTokenType.WHILE_END).addLocalScope().withLoopSemantics();
        this.visit(CPP14Parser.SelectionStatementContext.class, rule -> rule.Switch() != null).map((TokenType)CPPTokenType.SWITCH_BEGIN, (TokenType)CPPTokenType.SWITCH_END).addLocalScope().withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.SelectionStatementContext.class, rule -> rule.If() != null).map((TokenType)CPPTokenType.IF_BEGIN, (TokenType)CPPTokenType.IF_END).addLocalScope().withSemantics(CodeSemantics::createControl);
        this.visit(32).map((TokenType)CPPTokenType.ELSE).withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.LabeledStatementContext.class, rule -> rule.Case() != null).map((TokenType)CPPTokenType.CASE).withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.LabeledStatementContext.class, rule -> rule.Default() != null).map((TokenType)CPPTokenType.DEFAULT).withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.JumpStatementContext.class, rule -> rule.Break() != null).map((TokenType)CPPTokenType.BREAK).withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.JumpStatementContext.class, rule -> rule.Continue() != null).map((TokenType)CPPTokenType.CONTINUE).withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.JumpStatementContext.class, rule -> rule.Goto() != null).map((TokenType)CPPTokenType.GOTO).withSemantics(CodeSemantics::createControl);
        this.visit(CPP14Parser.JumpStatementContext.class, rule -> rule.Return() != null).map((TokenType)CPPTokenType.RETURN).withSemantics(CodeSemantics::createControl);
    }

    private void typeSpecifierRule() {
        this.visit(CPP14Parser.SimpleTypeSpecifierContext.class, rule -> {
            if (CPPListener.hasAncestor((ParserRuleContext)rule, CPP14Parser.MemberdeclarationContext.class, (Class[])new Class[]{CPP14Parser.FunctionDefinitionContext.class})) {
                return true;
            }
            CPP14Parser.SimpleDeclarationContext parent = (CPP14Parser.SimpleDeclarationContext)CPPListener.getAncestor((ParserRuleContext)rule, CPP14Parser.SimpleDeclarationContext.class, (Class[])new Class[]{CPP14Parser.TemplateArgumentContext.class, CPP14Parser.FunctionDefinitionContext.class});
            if (parent == null) {
                return false;
            }
            CPP14Parser.NoPointerDeclaratorContext noPointerDecl = (CPP14Parser.NoPointerDeclaratorContext)CPPListener.getDescendant((ParserRuleContext)parent, CPP14Parser.NoPointerDeclaratorContext.class);
            return !CPPListener.noPointerInFunctionCallContext(noPointerDecl) && !CPPListener.hasAncestor((ParserRuleContext)rule, CPP14Parser.NewTypeIdContext.class, (Class[])new Class[0]);
        }).map((TokenType)CPPTokenType.VARDEF).withSemantics(CodeSemantics::new).onEnter((context, variableRegistry) -> {
            CPP14Parser.SimpleDeclarationContext parent = (CPP14Parser.SimpleDeclarationContext)CPPListener.getAncestor((ParserRuleContext)context, CPP14Parser.SimpleDeclarationContext.class, (Class[])new Class[0]);
            if (parent == null) {
                throw new IllegalStateException();
            }
            variableRegistry.setNextVariableAccessType(VariableAccessType.WRITE);
            if (parent.initDeclaratorList() == null) {
                return;
            }
            for (CPP14Parser.InitDeclaratorContext dec : parent.initDeclaratorList().initDeclarator()) {
                String name = dec.declarator().pointerDeclarator().noPointerDeclarator().getText();
                VariableScope scope = variableRegistry.inLocalScope() ? VariableScope.LOCAL : VariableScope.FILE;
                variableRegistry.registerVariable(name, scope, true);
            }
        });
    }

    private void declarationRules() {
        this.mapApply(this.visit(CPP14Parser.SimpleDeclarationContext.class, rule -> {
            if (!CPPListener.hasAncestor((ParserRuleContext)rule, CPP14Parser.FunctionBodyContext.class, (Class[])new Class[0])) {
                return false;
            }
            CPP14Parser.NoPointerDeclaratorContext noPointerDecl = (CPP14Parser.NoPointerDeclaratorContext)CPPListener.getDescendant((ParserRuleContext)rule, CPP14Parser.NoPointerDeclaratorContext.class);
            return CPPListener.noPointerInFunctionCallContext(noPointerDecl);
        }));
        this.mapApply(this.visit(CPP14Parser.InitDeclaratorContext.class, rule -> rule.initializer() != null && rule.initializer().LeftParen() != null));
        this.visit(CPP14Parser.DeclaratorContext.class, rule -> {
            ParserRuleContext parent = rule.getParent();
            CPP14Parser.BraceOrEqualInitializerContext desc = (CPP14Parser.BraceOrEqualInitializerContext)CPPListener.getDescendant((ParserRuleContext)parent, CPP14Parser.BraceOrEqualInitializerContext.class);
            return desc != null && desc.Assign() != null && (parent == desc.getParent() || parent == desc.getParent().getParent());
        }).map((TokenType)CPPTokenType.ASSIGN).withSemantics(CodeSemantics::new).onEnter((ctx, varReg) -> varReg.setNextVariableAccessType(VariableAccessType.WRITE));
        this.visit(CPP14Parser.ParameterDeclarationContext.class).map((TokenType)CPPTokenType.VARDEF).withSemantics(CodeSemantics::new).onEnter((ctx, varReg) -> {
            if (CPPListener.hasAncestor((ParserRuleContext)ctx, CPP14Parser.FunctionDefinitionContext.class, (Class[])new Class[]{CPP14Parser.SimpleDeclarationContext.class}) && ctx.declarator() != null) {
                CPP14Parser.PointerDeclaratorContext pd = ctx.declarator().pointerDeclarator();
                String name = pd.noPointerDeclarator().getText();
                varReg.registerVariable(name, VariableScope.LOCAL, true);
                varReg.setNextVariableAccessType(VariableAccessType.WRITE);
            }
        });
    }

    private void expressionRules() {
        this.visit(CPP14Parser.ConditionalExpressionContext.class, rule -> rule.Question() != null).map((TokenType)CPPTokenType.QUESTIONMARK).withSemantics(CodeSemantics::new);
        this.mapApply(this.visit(CPP14Parser.PostfixExpressionContext.class, rule -> rule.LeftParen() != null));
        this.visit(CPP14Parser.PostfixExpressionContext.class, rule -> rule.PlusPlus() != null || rule.MinusMinus() != null).map((TokenType)CPPTokenType.ASSIGN).withSemantics(CodeSemantics::new).onEnter((rule, varReg) -> varReg.setNextVariableAccessType(VariableAccessType.READ_WRITE));
    }

    private void idRules() {
        this.visit(CPP14Parser.UnqualifiedIdContext.class).onEnter((ctx, varReg) -> {
            ParserRuleContext parentCtx = ctx.getParent().getParent();
            if (!parentCtx.getParent().getParent().getText().contains("(")) {
                boolean isClassVariable = parentCtx.getClass() == CPP14Parser.PostfixExpressionContext.class && ((CPP14Parser.PostfixExpressionContext)parentCtx).postfixExpression().getText().equals("this");
                varReg.registerVariableAccess(ctx.getText(), isClassVariable);
            }
        });
    }

    private void mapApply(ContextVisitor<?> visitor) {
        visitor.onExit((ctx, varReg) -> varReg.setMutableWrite(false)).onEnter((ctx, varReg) -> {
            varReg.addAllNonLocalVariablesAsReads();
            varReg.setMutableWrite(true);
        }).map((TokenType)CPPTokenType.APPLY).withControlSemantics();
    }

    private static boolean noPointerInFunctionCallContext(CPP14Parser.NoPointerDeclaratorContext context) {
        return context != null && (context.parametersAndQualifiers() != null || context.LeftParen() != null);
    }

    private void mapClass(Function<CPP14Parser.ClassKeyContext, TerminalNode> getTerminal, TokenType beginTokenType, TokenType endTokenType) {
        this.visit(CPP14Parser.ClassSpecifierContext.class, rule -> {
            CPP14Parser.ClassKeyContext classKey = rule.classHead().classKey();
            return classKey != null && getTerminal.apply(classKey) != null;
        }).map(beginTokenType, endTokenType).addClassScope().withSemantics(CodeSemantics::createControl).onEnter(this::registerClassVariables);
    }

    private void registerClassVariables(CPP14Parser.ClassSpecifierContext context, VariableRegistry variableRegistry) {
        CPP14Parser.MemberSpecificationContext members = context.memberSpecification();
        if (members != null) {
            for (CPP14Parser.MemberdeclarationContext member : members.memberdeclaration()) {
                if (member.memberDeclaratorList() == null) continue;
                for (CPP14Parser.MemberDeclaratorContext memberDec : member.memberDeclaratorList().memberDeclarator()) {
                    CPP14Parser.DeclaratorContext dec = memberDec.declarator();
                    if (dec == null) continue;
                    String name = dec.pointerDeclarator().noPointerDeclarator().getText();
                    variableRegistry.registerVariable(name, VariableScope.CLASS, true);
                }
            }
        }
    }
}

