/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.cpp.experimental;

import de.jplag.SharedTokenType;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.cpp.CPPTokenType;
import java.util.List;
import java.util.ListIterator;

public final class UnreachableCodeFilter {
    private UnreachableCodeFilter() {
    }

    public static void applyTo(List<Token> tokenList) {
        TokenFilterState stateMachine = TokenFilterState.STATE_DEFAULT;
        ListIterator<Token> iterator = tokenList.listIterator();
        while (iterator.hasNext()) {
            Token token = iterator.next();
            if (!(stateMachine = stateMachine.nextState(token.getType())).shouldTokenBeDeleted()) continue;
            iterator.remove();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum TokenFilterState {
        STATE_DEFAULT{

            @Override
            TokenFilterState nextState(TokenType nextType) {
                if (TokenFilterState.isBlockStartToken(nextType)) {
                    return STATE_BLOCK_BEGINNING;
                }
                if (TokenFilterState.isJumpToken(nextType)) {
                    return STATE_DEAD_BLOCK_BEGINNING;
                }
                if (nextType == CPPTokenType.C_CASE) {
                    return STATE_CASE_BLOCK;
                }
                return STATE_DEFAULT;
            }
        }
        ,
        STATE_BLOCK_BEGINNING{

            @Override
            TokenFilterState nextState(TokenType nextType) {
                if (TokenFilterState.isBlockEndToken(nextType) || nextType == CPPTokenType.C_BLOCK_BEGIN) {
                    return STATE_DEFAULT;
                }
                return STATE_BLOCK_BEGINNING;
            }
        }
        ,
        STATE_DEAD_BLOCK{

            @Override
            TokenFilterState nextState(TokenType nextType) {
                if (TokenFilterState.isBlockEndToken(nextType)) {
                    return STATE_DEFAULT;
                }
                if (nextType == CPPTokenType.C_CASE) {
                    return STATE_CASE_BLOCK;
                }
                return STATE_DEAD_BLOCK;
            }

            @Override
            public boolean shouldTokenBeDeleted() {
                return true;
            }
        }
        ,
        STATE_DEAD_BLOCK_BEGINNING{

            @Override
            TokenFilterState nextState(TokenType nextType) {
                if (TokenFilterState.isBlockEndToken(nextType)) {
                    return STATE_DEFAULT;
                }
                if (nextType == CPPTokenType.C_CASE) {
                    return STATE_CASE_BLOCK;
                }
                return STATE_DEAD_BLOCK;
            }
        }
        ,
        STATE_CASE_BLOCK{

            @Override
            TokenFilterState nextState(TokenType nextType) {
                if (TokenFilterState.isBlockEndToken(nextType)) {
                    return STATE_DEFAULT;
                }
                if (TokenFilterState.isJumpToken(nextType)) {
                    return STATE_DEAD_BLOCK_BEGINNING;
                }
                return STATE_CASE_BLOCK;
            }
        };


        private static boolean isBlockStartToken(TokenType token) {
            return token == CPPTokenType.C_WHILE || token == CPPTokenType.C_IF || token == CPPTokenType.C_FOR;
        }

        private static boolean isBlockEndToken(TokenType token) {
            return token == CPPTokenType.C_BLOCK_END || token == SharedTokenType.FILE_END;
        }

        private static boolean isJumpToken(TokenType token) {
            return token == CPPTokenType.C_RETURN || token == CPPTokenType.C_BREAK || token == CPPTokenType.C_CONTINUE || token == CPPTokenType.C_THROW || token == CPPTokenType.C_GOTO;
        }

        public boolean shouldTokenBeDeleted() {
            return false;
        }

        abstract TokenFilterState nextState(TokenType var1);
    }
}

