/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.c;

import de.jplag.AbstractParser;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.c.CPPScanner;
import de.jplag.c.CTokenType;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Scanner
extends AbstractParser {
    private File currentFile;
    private List<Token> tokens;

    public List<Token> scan(Set<File> files) throws ParsingException {
        this.tokens = new ArrayList<Token>();
        Iterator<File> iterator = files.iterator();
        while (iterator.hasNext()) {
            File file;
            this.currentFile = file = iterator.next();
            this.logger.trace("Scanning file {}", (Object)this.currentFile);
            try {
                CPPScanner.scanFile(file, this);
            }
            catch (ParsingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ParsingException(file, "Unexpected error during parsing." + System.lineSeparator() + e.getMessage(), (Throwable)e);
            }
            this.tokens.add(Token.fileEnd((File)this.currentFile));
        }
        return this.tokens;
    }

    public void add(CTokenType type, de.jplag.c.Token token) {
        int length = token.endColumn - token.beginColumn + 1;
        this.tokens.add(new Token((TokenType)type, this.currentFile, token.beginLine, token.beginColumn, length));
    }
}

