${license}
/**
This file was automatically generated by the OWL API Generator.
*/

package ${package};

import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

import de.jpdigital.owlapisimplex.OwlApiSimplexException;

public class ${className} extends ${baseClass} {
    
    <#if (baseClass == "de.jpdigital.owlapisimplex.OwlApiSimplexUtilsFromResourcesBuilder")>
    public ${className}() {
        super(Arrays.asList(new String[]{
        <#list ontologySources as source>
            "${source}"<#sep>,</#sep>
        </#list>
        }));
    }
    <#else>
    public ${className}(final List<Path> paths) {
        super(paths);
    }
    </#if>

    @Override
    protected void validate(final List<OWLOntology> ontologies)
        throws OwlApiSimplexException {
        final List<IRI> ontologyIris = Arrays.stream(new String[]{
            <#list ontologyIris as iri>
            "${iri}"<#sep>,</#sep>
            </#list>
        })
        .map(iri -> IRI.create(iri))
        .collect(Collectors.toList());
        for (final IRI iri : ontologyIris) {
            final boolean available = ontologies
                .stream()
                .anyMatch(
                    ontology -> ontology
                                    .getOntologyID()
                                    .getOntologyIRI()
                                    .equals(iri)
                ); 
            if (!available) {
                throw new OwlApiSimplexException(
                    String.format(
                        "Ontology %s has not been loaded.", iri
                    )
                );
            }
        }
    }
}
