/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owl.apigenerator.core;

import de.jpdigital.owl.apigenerator.core.UnexpectedErrorException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class TemplateService {
    private final Configuration configuration = new Configuration(Configuration.VERSION_2_3_29);
    private static final TemplateService INSTANCE = new TemplateService();

    private TemplateService() {
        this.configuration.setClassForTemplateLoading(this.getClass(), "/templates");
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }

    public static final TemplateService getTemplateService() {
        return INSTANCE;
    }

    public String processTemplate(String templateName, Map<String, Object> data) {
        try {
            Template template = this.configuration.getTemplate(templateName);
            StringWriter writer = new StringWriter();
            template.process(data, (Writer)writer);
            return writer.toString();
        }
        catch (TemplateException | IOException ex) {
            throw new UnexpectedErrorException((Exception)ex);
        }
    }
}

