/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owl.apigenerator.core;

import de.jpdigital.owl.apigenerator.core.OntologyLoaderGenerationFailedException;
import de.jpdigital.owl.apigenerator.core.OntologyOwlApi;
import de.jpdigital.owl.apigenerator.core.OwlFileSource;
import de.jpdigital.owl.apigenerator.core.TemplateService;
import de.jpdigital.owl.apigenerator.core.UnexpectedErrorException;
import de.jpdigital.owl.apigenerator.core.Utils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;

public class OntologyLoaderGenerator {
    private final OntologyOwlApi ontologyOwlApi;
    private final Path outputDir;
    private final OwlFileSource fileSource;
    private List<String> resourcePaths;

    private OntologyLoaderGenerator(OntologyOwlApi ontologyOwlApi, Path outputDir, OwlFileSource fileSource) {
        this.ontologyOwlApi = ontologyOwlApi;
        this.outputDir = outputDir;
        this.fileSource = fileSource;
    }

    private OntologyLoaderGenerator(OntologyOwlApi ontologyOwlApi, Path outputDir, OwlFileSource fileSource, List<String> resourcePaths) {
        this.ontologyOwlApi = ontologyOwlApi;
        this.outputDir = outputDir;
        this.fileSource = fileSource;
        this.resourcePaths = resourcePaths;
    }

    public static OntologyLoaderGenerator buildDirectoryOntologyLoaderGenerator(OntologyOwlApi ontologyOwlApi, Path outputDir) {
        OntologyLoaderGenerator.validateOutputDir(outputDir);
        Objects.requireNonNull(ontologyOwlApi, "ontologyOwlApi can't be null");
        return new OntologyLoaderGenerator(ontologyOwlApi, outputDir, OwlFileSource.DIRECTORY);
    }

    public static OntologyLoaderGenerator buildClassPathOntologyLoaderGenerator(OntologyOwlApi ontologyOwlApi, Path outputDir, List<String> resourcePaths) {
        OntologyLoaderGenerator.validateOutputDir(outputDir);
        Objects.requireNonNull(ontologyOwlApi, "ontologyOwlApi can't be null");
        Objects.requireNonNull(resourcePaths, "resourcePaths can't be null");
        if (resourcePaths.isEmpty()) {
            throw new IllegalArgumentException("resourcePath can't be empty.");
        }
        return new OntologyLoaderGenerator(ontologyOwlApi, outputDir, OwlFileSource.CLASS_PATH, resourcePaths);
    }

    private static void validateOutputDir(Path outputDir) {
        if (!Files.isDirectory(outputDir, new LinkOption[0])) {
            throw new IllegalArgumentException(String.format("The provided path \"%s\" is not a directory.", outputDir.toString()));
        }
        if (!Files.isWritable(outputDir)) {
            throw new IllegalArgumentException(String.format("The provided output directory \"%s\" is not writable.", outputDir.toString()));
        }
    }

    public void generateOntologyLoader() throws OntologyLoaderGenerationFailedException {
        String baseClass;
        String license = "";
        OWLOntology ontology = this.ontologyOwlApi.getOntology();
        IRI ontologyIri = this.getOntologyIri(ontology);
        String packageName = this.generatePackageName(ontologyIri);
        String className = "OntologyLoader";
        switch (this.fileSource) {
            case CLASS_PATH: {
                baseClass = "de.jpdigital.owlapisimplex.OwlApiSimplexUtilsFromResourcesBuilder";
                break;
            }
            case DIRECTORY: {
                baseClass = "de.jpdigital.owlapisimplex.OwlApiSimplexUtilsFromPathsBuilder";
                break;
            }
            default: {
                throw new UnexpectedErrorException(String.format("Unexpected value \"%s\" for fileSource.", this.fileSource.toString()));
            }
        }
        List ontologyIris = this.ontologyOwlApi.getLoadedOntologies().stream().map(this::getOntologyIri).map(IRI::toString).collect(Collectors.toList());
        HashMap<String, Object> dataModel = new HashMap<String, Object>();
        dataModel.put("license", "");
        dataModel.put("package", packageName);
        dataModel.put("className", "OntologyLoader");
        dataModel.put("baseClass", baseClass);
        dataModel.put("ontologyIris", ontologyIris);
        dataModel.put("ontologySources", this.resourcePaths);
        Path packagePath = Utils.generatePackagePath(packageName);
        TemplateService templateService = TemplateService.getTemplateService();
        String result = templateService.processTemplate("OntologyLoader.java.ftl", dataModel);
        Path packageDir = this.outputDir.resolve(packagePath);
        Path classFile = packageDir.resolve(String.format("%s.java", "OntologyLoader"));
        try {
            Files.createDirectories(packageDir, new FileAttribute[0]);
            Files.write(classFile, result.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException ex) {
            throw new OntologyLoaderGenerationFailedException(ex);
        }
    }

    private IRI getOntologyIri(OWLOntology ontology) {
        OWLOntologyID ontologyId = ontology.getOntologyID();
        Optional ontologyIri = ontologyId.getOntologyIRI();
        if (ontologyIri.isPresent()) {
            return (IRI)ontologyIri.get();
        }
        Optional versionIri = ontologyId.getVersionIRI();
        if (versionIri.isPresent()) {
            return (IRI)versionIri.get();
        }
        throw new UnexpectedErrorException("The provided ontology neither has an IRI or an version IRI. Unable to generate an OntologyLoader for this ontology.");
    }

    private String generatePackageName(IRI ontologyIri) {
        String packageName = Utils.generatePackageName(ontologyIri);
        if (packageName.endsWith(".")) {
            return packageName.substring(0, packageName.length() - 1);
        }
        return packageName;
    }
}

