/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.owl.apigenerator.core;

import java.nio.file.Path;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import org.semanticweb.owlapi.model.IRI;

class IriBundle {
    private final String namespace;
    private final String packageName;
    private final Path packagePath;
    private final String className;
    private final SortedSet<IRI> iris;

    IriBundle(String namespace, String packageName, Path packagePath, String className) {
        this.namespace = namespace;
        this.packageName = packageName;
        this.packagePath = packagePath;
        this.className = className;
        this.iris = new TreeSet<IRI>((iri1, iri2) -> iri1.toString().compareTo(iri2.toString()));
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Path getPackagePath() {
        return this.packagePath;
    }

    public String getClassName() {
        return this.className;
    }

    public SortedSet<IRI> getIris() {
        return Collections.unmodifiableSortedSet(this.iris);
    }

    public void addIri(IRI iri) {
        this.iris.add(iri);
    }
}

