/*
 * Decompiled with CFR 0.152.
 */
package de.jpdigital.maven.plugins.hibernate5ddl;

import de.jpdigital.maven.plugins.hibernate5ddl.DdlGenerator;
import de.jpdigital.maven.plugins.hibernate5ddl.Dialect;
import de.jpdigital.maven.plugins.hibernate5ddl.GenerateDdlMojo;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DdlGeneratorHibernate52
implements DdlGenerator {
    public void generateDdl(Dialect dialect, Set<Class<?>> entityClasses, GenerateDdlMojo mojo) throws MojoFailureException {
        Path tmpDir;
        StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder();
        this.processPersistenceXml(registryBuilder, mojo.getPersistenceXml(), mojo.getLog());
        if (mojo.isCreateDropStatements()) {
            registryBuilder.applySetting("hibernate.hbm2ddl.auto", (Object)"create-drop");
        } else {
            registryBuilder.applySetting("hibernate.hbm2ddl.auto", (Object)"create");
        }
        registryBuilder.applySetting("hibernate.dialect", (Object)dialect.getDialectClass());
        StandardServiceRegistry standardRegistry = registryBuilder.build();
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)standardRegistry);
        for (Class<?> entityClass : entityClasses) {
            metadataSources.addAnnotatedClass(entityClass);
        }
        SchemaExport export = new SchemaExport();
        export.setDelimiter(";");
        try {
            tmpDir = Files.createTempDirectory("maven-hibernate5-ddl-plugin", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new MojoFailureException("Failed to create work dir.", (Throwable)ex);
        }
        Metadata metadata = metadataSources.buildMetadata();
        export.setOutputFile(String.format("%s/%s.sql", tmpDir.toString(), dialect.name().toLowerCase(Locale.ENGLISH)));
        export.setFormat(true);
        if (mojo.isCreateDropStatements()) {
            export.execute(EnumSet.of(TargetType.SCRIPT), SchemaExport.Action.BOTH, metadata);
        } else {
            export.execute(EnumSet.of(TargetType.SCRIPT), SchemaExport.Action.CREATE, metadata);
        }
        mojo.writeOutputFile(dialect, tmpDir);
    }

    private void processPersistenceXml(StandardServiceRegistryBuilder registryBuilder, File persistenceXml, Log log) {
        if (persistenceXml != null) {
            if (Files.exists(persistenceXml.toPath(), new LinkOption[0])) {
                try (FileInputStream inputStream = new FileInputStream(persistenceXml);){
                    log.info((CharSequence)"persistence.xml found, looking for properties...");
                    SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
                    parser.parse((InputStream)inputStream, (DefaultHandler)new PersistenceXmlHandler(registryBuilder, log));
                }
                catch (IOException ex) {
                    log.error((CharSequence)"Failed to open persistence.xml. Not processing properties.", (Throwable)ex);
                }
                catch (ParserConfigurationException | SAXException ex) {
                    log.error((CharSequence)"Error parsing persistence.xml. Not processing properties", (Throwable)ex);
                }
            } else {
                log.warn((CharSequence)String.format("persistence.xml file '%s' does not exist. Ignoring.", persistenceXml.getPath()));
            }
        }
    }

    private static class PersistenceXmlHandler
    extends DefaultHandler {
        private final transient StandardServiceRegistryBuilder registryBuilder;
        private final transient Log log;

        public PersistenceXmlHandler(StandardServiceRegistryBuilder registryBuilder, Log log) {
            this.registryBuilder = registryBuilder;
            this.log = log;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.log.info((CharSequence)String.format("Found element with uri = '%s', localName = '%s', qName = '%s'...", uri, localName, qName));
            if ("property".equals(qName)) {
                String propertyName = attributes.getValue("name");
                String propertyValue = attributes.getValue("value");
                if (propertyName != null && !propertyName.isEmpty() && propertyValue != null && !propertyValue.isEmpty()) {
                    this.log.info((CharSequence)String.format("Found property %s = %s in persistence.xml", propertyName, propertyValue));
                    this.registryBuilder.applySetting(propertyName, (Object)propertyValue);
                }
            }
        }
    }
}

