/*
 * Decompiled with CFR 0.152.
 */
package de.joshuaschnabel.l18n;

import com.eclipsesource.json.Json;
import de.joshuaschnabel.l18n.I18n;
import de.joshuaschnabel.l18n.Translation;
import de.joshuaschnabel.l18n.exception.LanguageNotSupportedException;
import de.joshuaschnabel.l18n.json.JsonTranslationDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class I18nSingleFile
extends I18n {
    public I18nSingleFile(Locale defaultLanguage) {
        super(defaultLanguage);
    }

    @Override
    protected void checkIfLanguageIsLoaded(Locale language) {
        if (!this.getSupportedLanguages().contains(language)) {
            throw new LanguageNotSupportedException("Language " + language.getDisplayName() + " is not supported");
        }
    }

    @Override
    protected void loadLanguages() {
        InputStream is = I18n.class.getClass().getResourceAsStream("/jsI18n/i18n.tns");
        try (InputStreamReader reader = new InputStreamReader(is, Charset.forName("UTF-8"));){
            HashMap<Locale, String> supportedLanguages = new HashMap<Locale, String>();
            HashMap<Locale, Translation> translations = new HashMap<Locale, Translation>();
            List<Translation> tempTrans = JsonTranslationDeserializer.deserialise(Json.parse((Reader)reader).asObject());
            for (Translation translation : tempTrans) {
                for (Locale locale : translation.getLanguages()) {
                    supportedLanguages.put(locale, null);
                    translations.put(locale, translation);
                }
            }
            this.setSupportedLanguages(supportedLanguages);
            this.setTranslations(translations);
        }
        catch (IOException e) {
            throw new IllegalStateException("File 'jsI18n/i18n.tns' not found! (" + e.getMessage() + ")");
        }
    }
}

