/**
 * ResourceScanner.java
 *
 * Copyright 2016 Joshua Schnabel
 * 
 * Created: 22.11.2016 14:58:31
 * Part of: jsI18n
 * 
 * For licence informations check the LICENCE file!
 */
package de.joshuaschnabel.l18n.scanner;

import java.util.Set;
import java.util.regex.Pattern;

import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;

/**
 * Class scans resources for files
 * 
 * @author Joshua Schnabel
 *
 */
public final class ResourceScanner
{
	/**
	 * Search files in the resource folder
	 * 
	 * @param packageName
	 *           - packagename in which to search for files
	 * @param pattern
	 *           - pattern which must match the filename
	 * @return a list of filenames
	 */
	public static Set<String> getResources(String packageName, String pattern)
	{
		return new Reflections(packageName, new ResourcesScanner()).getResources(Pattern.compile(pattern));
	}
}
