/**
 * JsonSerializer.java
 *
 * Copyright 2016 Joshua Schnabel
 * 
 * Created: 08.11.2016 21:34:19
 * Part of: jsConfig
 * 
 * For licence informations check the LICENCE file!
 */
package de.joshuaschnabel.l18n.json;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonObject.Member;
import com.eclipsesource.json.JsonValue;

import de.joshuaschnabel.l18n.Translation;

/**
 * Deserializer a {@link JsonObject} into {@link Translation} Objects
 * 
 * @author Joshua Schnabel
 *
 */
public final class JsonTranslationDeserializer
{

	/**
	 * Deserializer a {@link JsonObject} into {@link Translation} objects
	 * 
	 * @param object
	 *           - a JsonObject
	 * @return a list of {@link Translation}s
	 */
	public static List<Translation> deserialise(JsonObject object)
	{
		ArrayList<Translation> translations = new ArrayList<>();

		for (Member member : object)
		{
			translations.add(deserialiseTranslation(member.getValue().asObject()));
		}

		return translations;
	}

	/**
	 * Deserializer a {@link JsonObject} into a {@link Translation} object
	 * 
	 * @param object
	 *           - a JsonObject
	 * @return a {@link Translation} object
	 */
	public static Translation deserialiseTranslation(JsonObject object)
	{
		ArrayList<Locale> languages = new ArrayList<>();
		for (JsonValue member : object.get("language").asArray())
		{
			languages.add(Locale.forLanguageTag(member.asString()));
		}

		Translation translation = new Translation(languages);

		for (Member member : object)
		{
			if (!member.getName().equals("language")) translation.addString(member.getName(), member.getValue().asString());
		}

		return translation;
	}

}
