/**
 * Translation.java
 *
 * Copyright 2016 Joshua Schnabel
 * 
 * Created: 18.11.2016 18:18:21
 * Part of: jsI18n
 * 
 * For licence informations check the LICENCE file!
 */
package de.joshuaschnabel.l18n;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/**
 * This class wraps a list of translation strings
 * 
 * @author Joshua Schnabel
 *
 */
public class Translation
{
	private List<Locale>				languages;
	private Map<String, String>	strings	= new HashMap<>();

	/**
	 * This class wraps a list of translation strings
	 * 
	 * @param languages
	 *           - languages of the translation
	 * 
	 */
	public Translation(List<Locale> languages)
	{
		this.languages = languages;
	}

	/**
	 * @return the languages of the translation
	 */
	public List<Locale> getLanguages()
	{
		return this.languages;
	}

	/**
	 * get a translation string by a identifier
	 * 
	 * @param identifier
	 *           - identifier of the translation string
	 * @return the translation string
	 */
	public String getString(String identifier)
	{
		return this.strings.get(identifier);
	}

	/**
	 * add a translation string by a identifier
	 * 
	 * @param identifier
	 *           -
	 *           identifier of the translation string
	 * @param value
	 *           - the translation string
	 */
	public void addString(String identifier, String value)
	{
		this.strings.put(identifier, value);
	}
}
