/**
 * I18nSingleFile.java
 *
 * Copyright 2016 Joshua Schnabel
 * 
 * Created: 02.12.2016 18:33:07
 * Part of: jsI18n
 * 
 * For licence informations check the LICENCE file!
 */
package de.joshuaschnabel.l18n;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

import com.eclipsesource.json.Json;

import de.joshuaschnabel.l18n.exception.LanguageNotSupportedException;
import de.joshuaschnabel.l18n.json.JsonTranslationDeserializer;

/**
 * @author Joshua Schnabel
 *
 *         TODO Description
 *
 */
public class I18nSingleFile extends I18n
{

	/**
	 * Description: {@link I18nSingleFile}
	 *
	 * @param defaultLanguage
	 *           - Locale of the default language
	 */
	public I18nSingleFile(Locale defaultLanguage)
	{
		super(defaultLanguage);
	}

	/**
	 * @see de.joshuaschnabel.l18n.I18n#checkIfLanguageIsLoaded(java.util.Locale)
	 */
	@Override
	protected void checkIfLanguageIsLoaded(Locale language)
	{
		if (!this.getSupportedLanguages().contains(language))
			throw new LanguageNotSupportedException("Language " + language.getDisplayName() + " is not supported");
	}

	/**
	 * 
	 * @see de.joshuaschnabel.l18n.I18n#loadLanguages()
	 */
	@Override
	protected void loadLanguages()
	{
		InputStream is = I18n.class.getClass().getResourceAsStream("/jsI18n/i18n.tns");
		try (InputStreamReader reader = new InputStreamReader(is, Charset.forName("UTF-8")))
		{
			HashMap<Locale, String> supportedLanguages = new HashMap<>();
			HashMap<Locale, Translation> translations = new HashMap<>();

			List<Translation> tempTrans = JsonTranslationDeserializer.deserialise(Json.parse(reader).asObject());

			for (Translation translation : tempTrans)
			{
				for (Locale locale : translation.getLanguages())
				{
					supportedLanguages.put(locale, null);
					translations.put(locale, translation);
				}
			}
			this.setSupportedLanguages(supportedLanguages);
			this.setTranslations(translations);
		}
		catch (IOException e)
		{
			throw new IllegalStateException("File 'jsI18n/i18n.tns' not found! (" + e.getMessage() + ")");
		}
	}

}
