/**
 * Copyright 2015 Tobias Jonas
 * License: Apache2 || http://www.apache.org/licenses/LICENSE-2.0
 */
package de.jonato.keyboardfx;

/*
 * #%L
 * keyboard.fx
 * %%
 * Copyright (C) 2015 Jonato IT Solutions
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


import javafx.scene.input.KeyCode;

public interface IKeyboard {

    /**
     * Route a KeyStroke to a KeyboardCallback event.
     * @param keyStroke Keys for listening
     * @param keyboardCallback Fired Event
     */
    public void addKeyStroke(KeyStroke keyStroke, KeyboardCallback keyboardCallback);

    /**
     * Remove a event from a Key oder KeyStroke.
     * @param keyStroke Effected Keys
     * @param keyboardCallback Effected events
     */
    public void removeKeyStrokeCall(KeyStroke keyStroke, KeyboardCallback keyboardCallback);

    /**
     * Remove all actions from a KeyStroke.
     * @param keyStroke Effected Keys
     */
    public void removeKeyStroke(KeyStroke keyStroke);

}
