/**
 * Copyright 2015 Tobias Jonas
 * License: Apache2 || http://www.apache.org/licenses/LICENSE-2.0
 */
package de.jonato.keyboardfx;

/*
 * #%L
 * keyboard.fx
 * %%
 * Copyright (C) 2015 Jonato IT Solutions
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */


import javafx.scene.input.KeyEvent;

import java.util.HashMap;
import java.util.HashSet;

public abstract class AbstractKeyboard implements IKeyboard {
    private KeyStroke currentKeyStroke = new KeyStroke();
    protected HashMap<KeyStroke, HashSet<KeyboardCallback>> actions = new HashMap<>();

    protected void putAction(KeyStroke keyStroke, KeyboardCallback keyboardCallback){
        if(!actions.containsKey(keyStroke)){
            actions.put(keyStroke, new HashSet<>());
        }
        actions.get(keyStroke).add(keyboardCallback);
    }

    protected void removeAllActions(KeyStroke keyStroke){
        if(actions.containsKey(keyStroke)){
            actions.remove(keyStroke);
        }
    }
    protected void removeAction(KeyStroke keyStroke, KeyboardCallback keyboardCallback){
        if(actions.containsKey(keyStroke) && actions.get(keyStroke).contains(keyboardCallback)){
            actions.get(keyStroke).remove(keyboardCallback);
        }
    }

    public KeyStroke getCurrentKeyStroke() {
        return currentKeyStroke;
    }

    public void setCurrentKeyStroke(KeyStroke currentKeyStroke) {
        this.currentKeyStroke = currentKeyStroke;
    }

    public void setKeyDownEvent(KeyEvent keyEvent){
        currentKeyStroke.addKey(keyEvent.getCode());
        if(actions.containsKey(currentKeyStroke)){
            actions.get(currentKeyStroke).forEach(inv -> inv.keyboardAction(currentKeyStroke));
        }
    }
    public void setKeyUpEvent(KeyEvent keyEvent){
        currentKeyStroke.removeKey(keyEvent.getCode());
    }
}
