/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.keyboard;

import de.jonato.jfxc.keyboard.AbstractKeyboard;
import de.jonato.jfxc.keyboard.CombinationCallback;
import de.jonato.jfxc.keyboard.KeyStroke;
import de.jonato.jfxc.keyboard.KeyboardCallback;
import javafx.scene.Scene;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;

public class SceneKeyboard
extends AbstractKeyboard {
    private Scene target;

    public SceneKeyboard(Scene scene) {
        this(scene, null);
    }

    public SceneKeyboard(Scene scene, Stage stage) {
        this.target = scene;
        scene.setOnKeyPressed(key -> this.setKeyDownEvent((KeyEvent)key));
        scene.setOnKeyReleased(key -> this.setKeyUpEvent((KeyEvent)key));
        if (stage != null) {
            stage.focusedProperty().addListener((o, ov, nv) -> {
                if (!nv.booleanValue()) {
                    this.setCurrentKeyStroke(new KeyStroke());
                }
            });
        }
    }

    @Override
    public void addKeyStroke(KeyStroke keyStroke, KeyboardCallback keyboardCallback) {
        this.putAction(keyStroke, keyboardCallback);
    }

    @Override
    public void removeKeyStroke(KeyStroke keyStroke) {
        this.removeAllActions(keyStroke);
    }

    @Override
    public void addKeyCombination(KeyCombination keyCombination, CombinationCallback combinationCallback) {
        this.putCombination(keyCombination, combinationCallback);
    }

    @Override
    public void removeKeyCombinationCall(KeyCombination keyCombination, CombinationCallback combinationCallback) {
        this.removeCombination(keyCombination, combinationCallback);
    }

    @Override
    public void removeKeyCombination(KeyCombination keyCombination) {
        this.removeAllCombinations(keyCombination);
    }

    @Override
    public void removeKeyStrokeCall(KeyStroke keyStroke, KeyboardCallback keyboardCallback) {
        this.removeAction(keyStroke, keyboardCallback);
    }

    public Scene getTarget() {
        return this.target;
    }
}

