/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.keyboard;

import de.jonato.jfxc.info.OS;
import de.jonato.jfxc.keyboard.CombinationCallback;
import de.jonato.jfxc.keyboard.IKeyboard;
import de.jonato.jfxc.keyboard.KeyStroke;
import de.jonato.jfxc.keyboard.KeyboardCallback;
import java.util.HashMap;
import java.util.HashSet;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;

public abstract class AbstractKeyboard
implements IKeyboard {
    private KeyStroke currentKeyStroke = new KeyStroke();
    protected HashMap<KeyStroke, HashSet<KeyboardCallback>> actions = new HashMap();
    protected HashMap<KeyCombination, HashSet<CombinationCallback>> combinations = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putCombination(KeyCombination keyCombination, CombinationCallback combinationCallback) {
        HashMap<KeyCombination, HashSet<CombinationCallback>> hashMap = this.combinations;
        synchronized (hashMap) {
            if (!this.combinations.containsKey(keyCombination)) {
                this.combinations.put(keyCombination, new HashSet());
            }
            HashSet<CombinationCallback> hashSet = this.combinations.get(keyCombination);
            synchronized (hashSet) {
                this.combinations.get(keyCombination).add(combinationCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void putAction(KeyStroke keyStroke, KeyboardCallback keyboardCallback) {
        HashMap<KeyStroke, HashSet<KeyboardCallback>> hashMap = this.actions;
        synchronized (hashMap) {
            if (!this.actions.containsKey(keyStroke)) {
                this.actions.put(keyStroke, new HashSet());
            }
            HashSet<KeyboardCallback> hashSet = this.actions.get(keyStroke);
            synchronized (hashSet) {
                this.actions.get(keyStroke).add(keyboardCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllCombinations(KeyCombination keyCombination) {
        HashMap<KeyCombination, HashSet<CombinationCallback>> hashMap = this.combinations;
        synchronized (hashMap) {
            if (this.combinations.containsKey(keyCombination)) {
                this.combinations.remove(keyCombination);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllActions(KeyStroke keyStroke) {
        HashMap<KeyStroke, HashSet<KeyboardCallback>> hashMap = this.actions;
        synchronized (hashMap) {
            if (this.actions.containsKey(keyStroke)) {
                this.actions.remove(keyStroke);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeCombination(KeyCombination keyCombination, CombinationCallback combinationCallback) {
        HashMap<KeyCombination, HashSet<CombinationCallback>> hashMap = this.combinations;
        synchronized (hashMap) {
            if (this.combinations.containsKey(keyCombination) && this.combinations.get(keyCombination).contains(combinationCallback)) {
                HashSet<CombinationCallback> hashSet = this.combinations.get(keyCombination);
                synchronized (hashSet) {
                    this.combinations.get(keyCombination).remove(combinationCallback);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAction(KeyStroke keyStroke, KeyboardCallback keyboardCallback) {
        HashMap<KeyStroke, HashSet<KeyboardCallback>> hashMap = this.actions;
        synchronized (hashMap) {
            if (this.actions.containsKey(keyStroke) && this.actions.get(keyStroke).contains(keyboardCallback)) {
                HashSet<KeyboardCallback> hashSet = this.actions.get(keyStroke);
                synchronized (hashSet) {
                    this.actions.get(keyStroke).remove(keyboardCallback);
                }
            }
        }
    }

    public KeyStroke getCurrentKeyStroke() {
        return this.currentKeyStroke;
    }

    public void setCurrentKeyStroke(KeyStroke currentKeyStroke) {
        this.currentKeyStroke = currentKeyStroke;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyDownEvent(KeyEvent keyEvent) {
        KeyStroke keyStroke = this.currentKeyStroke;
        synchronized (keyStroke) {
            this.currentKeyStroke.addKey(keyEvent.getCode());
            if (keyEvent.isAltDown()) {
                this.currentKeyStroke.addKey(KeyCode.ALT);
            } else {
                this.currentKeyStroke.removeKey(KeyCode.ALT);
            }
            if (keyEvent.isControlDown()) {
                this.currentKeyStroke.addKey(KeyCode.CONTROL);
            } else {
                this.currentKeyStroke.removeKey(KeyCode.CONTROL);
            }
            if (keyEvent.isShiftDown()) {
                this.currentKeyStroke.addKey(KeyCode.SHIFT);
            } else {
                this.currentKeyStroke.removeKey(KeyCode.SHIFT);
            }
            if (keyEvent.isMetaDown()) {
                if (OS.isMacOSX()) {
                    this.currentKeyStroke.addKey(KeyCode.COMMAND);
                } else if (OS.isWindows()) {
                    this.currentKeyStroke.addKey(KeyCode.WINDOWS);
                }
            } else {
                this.currentKeyStroke.removeKey(KeyCode.COMMAND);
                this.currentKeyStroke.removeKey(KeyCode.WINDOWS);
            }
            HashMap<KeyStroke, HashSet<Object>> hashMap = this.actions;
            synchronized (hashMap) {
                if (this.actions.containsKey(this.currentKeyStroke)) {
                    HashSet<KeyboardCallback> hashSet = this.actions.get(this.currentKeyStroke);
                    synchronized (hashSet) {
                        this.actions.get(this.currentKeyStroke).forEach(inv -> inv.keyboardAction(this.currentKeyStroke, keyEvent));
                    }
                }
            }
            hashMap = this.combinations;
            synchronized (hashMap) {
                this.combinations.forEach((keyCombination, keyboardCallbacks) -> {
                    if (keyCombination.match(keyEvent)) {
                        HashSet hashSet = keyboardCallbacks;
                        synchronized (hashSet) {
                            keyboardCallbacks.forEach(inv -> inv.keyboardCombination((KeyCombination)keyCombination, keyEvent));
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyUpEvent(KeyEvent keyEvent) {
        KeyStroke keyStroke = this.currentKeyStroke;
        synchronized (keyStroke) {
            if (keyEvent.isAltDown()) {
                this.currentKeyStroke.removeKey(KeyCode.ALT);
            }
            if (keyEvent.isControlDown()) {
                this.currentKeyStroke.removeKey(KeyCode.CONTROL);
            }
            if (keyEvent.isShiftDown()) {
                this.currentKeyStroke.removeKey(KeyCode.SHIFT);
            }
            if (keyEvent.isShortcutDown()) {
                this.currentKeyStroke.removeKey(KeyCode.SHORTCUT);
            }
            this.currentKeyStroke.removeKey(keyEvent.getCode());
        }
    }

    public void resetKeyStroke() {
        this.currentKeyStroke = new KeyStroke();
    }
}

