/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.info;

import de.jonato.jfxc.info.Version;
import java.util.HashMap;
import java.util.Map;

public class CurrentSystem {
    private static String javaVersion;
    private static String fileSeparator;
    private static String javaHome;

    public static String getJavaVersion() {
        if (javaVersion == null) {
            javaVersion = System.getProperty("java.version");
        }
        return javaVersion;
    }

    public static boolean hasJavaVersion(JAVA_VERSION version) {
        return Version.compareVersions(CurrentSystem.getJavaVersion(), version.get()) > 0;
    }

    public static String getSeparator() {
        if (fileSeparator == null) {
            fileSeparator = System.getProperty("file.separator");
        }
        return fileSeparator;
    }

    public static String getJavaHome() {
        if (javaHome == null) {
            javaHome = System.getProperty("java.home");
        }
        return javaHome;
    }

    public static void setProxy(String host, String port, String user, String password) {
        System.getProperties().put("http.proxyHost", host);
        System.getProperties().put("http.proxyPort", port);
        System.getProperties().put("http.proxyUser", user);
        System.getProperties().put("http.proxyPassword", password);
    }

    public static Map<String, String> getProxy() {
        HashMap<String, String> proxy = new HashMap<String, String>();
        proxy.put("host", System.getProperties().getProperty("http.proxyHost"));
        proxy.put("port", System.getProperties().getProperty("http.proxyPort"));
        proxy.put("user", System.getProperties().getProperty("http.proxyUser"));
        proxy.put("password", System.getProperties().getProperty("http.proxyPassword"));
        return proxy;
    }

    public static void removeProxy() {
        System.clearProperty("http.proxyHost");
    }

    public static enum JAVA_VERSION {
        JAVA9("1.9"),
        JAVA8("1.8"),
        JAVA7("1.7"),
        JAVA6("1.6"),
        JAVA5("1.5"),
        JAVA4("1.4"),
        JAVA3("1.3"),
        JAVA2("1.2"),
        JAVA1("1.1");

        private String version;

        private JAVA_VERSION(String version) {
            this.version = version;
        }

        public String get() {
            return this.version;
        }
    }
}

