/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.controls.textfield;

import de.jonato.jfxc.controls.textfield.TextFieldValidator;
import javafx.geometry.Pos;
import javafx.scene.control.TextField;

public class TypedTextField
extends TextField {
    private String numericLastKey;
    protected TextFieldValidator validator;

    public TypedTextField() {
        this("", TextFieldValidator.STRING);
    }

    public TypedTextField(String value) {
        this(value, TextFieldValidator.STRING);
    }

    public TypedTextField(String value, TextFieldValidator textFieldValidator) {
        this.validator = textFieldValidator;
        this.setAlignment(Pos.BASELINE_RIGHT);
        this.textProperty().addListener((observable, oldValue, newValue) -> {
            String validatedValue = "";
            if (!newValue.equals(validatedValue)) {
                try {
                    validatedValue = this.validator.validate((String)newValue);
                }
                catch (Exception e) {
                    validatedValue = oldValue;
                }
                finally {
                    this.setText(validatedValue);
                }
            }
        });
        this.focusedProperty().addListener((ob, ov, nv) -> {
            if (!nv.booleanValue()) {
                try {
                    this.validator.validateHard(this.getText());
                }
                catch (Exception e) {
                    this.setText(this.validator.defaultValue());
                }
            }
        });
    }

    public TextFieldValidator getValidator() {
        return this.validator;
    }

    public void setValidator(TextFieldValidator validator) {
        this.validator = validator;
    }
}

