/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.controls.textfield;

import java.util.regex.Pattern;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleLongProperty;
import javafx.scene.control.IndexRange;
import javafx.scene.control.TextField;

public abstract class TimeTextField
extends TextField {
    protected Pattern timePattern;
    protected ReadOnlyIntegerWrapper hours;
    protected ReadOnlyIntegerWrapper minutes;
    protected ReadOnlyIntegerWrapper seconds;
    protected SimpleLongProperty time;

    public TimeTextField(String time) {
        super(time);
    }

    public void appendText(String text) {
    }

    public boolean deleteNextChar() {
        boolean success = false;
        IndexRange selection = this.getSelection();
        if (selection.getLength() > 0) {
            int selectionEnd = selection.getEnd();
            this.deleteText(selection);
            this.positionCaret(selectionEnd);
            success = true;
        } else {
            int caret = this.getCaretPosition();
            if (caret % 3 != 2) {
                String currentText = this.getText();
                this.setText(currentText.substring(0, caret) + "0" + currentText.substring(caret + 1));
                success = true;
            }
            this.positionCaret(Math.min(caret + 1, this.getText().length()));
        }
        return success;
    }

    public boolean deletePreviousChar() {
        boolean success = false;
        IndexRange selection = this.getSelection();
        if (selection.getLength() > 0) {
            int selectionStart = selection.getStart();
            this.deleteText(selection);
            this.positionCaret(selectionStart);
            success = true;
        } else {
            int caret = this.getCaretPosition();
            if (caret % 3 != 0) {
                String currentText = this.getText();
                this.setText(currentText.substring(0, caret - 1) + "0" + currentText.substring(caret));
                success = true;
            }
            this.positionCaret(Math.max(caret - 1, 0));
        }
        return success;
    }

    public void deleteText(IndexRange range) {
        this.deleteText(range.getStart(), range.getEnd());
    }

    public void deleteText(int begin, int end) {
        StringBuilder builder = new StringBuilder(this.getText());
        for (int c = begin; c < end; ++c) {
            if (c % 3 == 2) continue;
            builder.replace(c, c + 1, "0");
        }
        this.setText(builder.toString());
    }

    public void insertText(int index, String text) {
        StringBuilder builder = new StringBuilder(this.getText());
        builder.replace(index, index + text.length(), text);
        String testText = builder.toString();
        if (this.validate(testText)) {
            this.setText(testText);
        }
        if (index != 0 && index % 3 == 1) {
            ++index;
        }
        this.positionCaret(index + text.length());
    }

    public void replaceSelection(String replacement) {
        IndexRange selection = this.getSelection();
        if (selection.getLength() == 0) {
            this.insertText(selection.getStart(), replacement);
        } else {
            this.replaceText(selection.getStart(), selection.getEnd(), replacement);
        }
    }

    public void replaceText(IndexRange range, String text) {
        this.replaceText(range.getStart(), range.getEnd(), text);
    }

    public void replaceText(int begin, int end, String text) {
        if (begin == end) {
            this.insertText(begin, text);
        } else if (text.length() == end - begin) {
            StringBuilder builder = new StringBuilder(this.getText());
            builder.replace(begin, end, text);
            String testText = builder.toString();
            if (this.validate(testText)) {
                this.setText(testText);
            }
            this.positionCaret(end);
        }
    }

    protected abstract boolean validate(String var1);

    public SimpleLongProperty timeProperty() {
        return this.time;
    }

    protected static final class TimeUnitBinding<E extends Enum<E>>
    extends IntegerBinding {
        E unit;
        final /* synthetic */ TimeTextField this$0;

        TimeUnitBinding(E unit) {
            this.this$0 = this$0;
            this.bind(new Observable[]{this$0.textProperty()});
            this.unit = unit;
        }

        protected int computeValue() {
            String token = this.this$0.getText().split(":")[((Enum)this.unit).ordinal()];
            return Integer.parseInt(token);
        }
    }
}

