/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.controls.textfield;

import java.math.BigInteger;
import java.util.regex.Pattern;

public enum TextFieldValidator {
    LONG(Long.class),
    INT(Integer.class),
    DOUBLE(Double.class),
    FLOAT(Float.class),
    STRING(String.class),
    BIG_INT(BigInteger.class);

    private Class<?> clazz;

    private TextFieldValidator(Class<?> clazz) {
        this.clazz = clazz;
    }

    private int countChar(String input, char Chat) {
        int i = 0;
        for (char c : input.toCharArray()) {
            if (c != Chat) continue;
            ++i;
        }
        return i;
    }

    public String validate(String value) throws Exception {
        if (this.clazz.equals(Long.class)) {
            value = Long.valueOf(value).toString();
        } else if (this.clazz.equals(Integer.class)) {
            value = Integer.valueOf(value).toString();
        } else if (this.clazz.equals(Float.class)) {
            Pattern p = Pattern.compile("[0-9]*\\.?[0-9]+");
            if (!p.matcher(value).matches() && !value.endsWith(".") || this.countChar(value, '.') > 1) {
                throw new Exception("not a number");
            }
        } else if (this.clazz.equals(Double.class)) {
            Pattern p = Pattern.compile("[0-9]*\\.?[0-9]+");
            if (!p.matcher(value).matches() && !value.endsWith(".") || this.countChar(value, '.') > 1) {
                throw new Exception("not a number");
            }
        } else if (this.clazz.equals(BigInteger.class)) {
            value = new BigInteger(value).toString();
        }
        return value;
    }

    public String validateHard(String value) throws Exception {
        if (this.clazz.equals(Long.class)) {
            value = Long.valueOf(value).toString();
        } else if (this.clazz.equals(Integer.class)) {
            value = Integer.valueOf(value).toString();
        } else if (this.clazz.equals(Float.class)) {
            value = Float.valueOf(value).toString();
        } else if (this.clazz.equals(Double.class)) {
            value = Double.valueOf(value).toString();
        } else if (this.clazz.equals(Boolean.class)) {
            value = Boolean.valueOf(value).toString();
        } else if (this.clazz.equals(BigInteger.class)) {
            value = new BigInteger(value).toString();
        }
        return value;
    }

    public String defaultValue() {
        String value = "";
        if (this.clazz.equals(Long.class)) {
            value = "0";
        } else if (this.clazz.equals(Integer.class)) {
            value = "0";
        } else if (this.clazz.equals(Float.class)) {
            value = "0.0";
        } else if (this.clazz.equals(Double.class)) {
            value = "0.0";
        } else if (this.clazz.equals(BigInteger.class)) {
            value = "0";
        }
        return value;
    }
}

