/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.controls.textfield;

import de.jonato.jfxc.controls.textfield.TimeTextField;
import java.util.regex.Pattern;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;

public class HourMinSecTextField
extends TimeTextField {
    public HourMinSecTextField() {
        this("00:00:00");
    }

    public HourMinSecTextField(String time) {
        super(time);
        this.time = new SimpleLongProperty();
        this.timePattern = Pattern.compile("\\d\\d:\\d\\d:\\d\\d");
        if (!this.validate(time)) {
            throw new IllegalArgumentException("Invalid time: " + time);
        }
        this.hours = new ReadOnlyIntegerWrapper((Object)this, "hours");
        this.minutes = new ReadOnlyIntegerWrapper((Object)this, "minutes");
        this.hours.bind((ObservableValue)new TimeTextField.TimeUnitBinding((TimeTextField)this, (Enum)Unit.HOURS));
        this.minutes.bind((ObservableValue)new TimeTextField.TimeUnitBinding((TimeTextField)this, (Enum)Unit.MINUTES));
        this.seconds = new ReadOnlyIntegerWrapper((Object)this, "seconds");
        this.seconds.bind((ObservableValue)new TimeTextField.TimeUnitBinding((TimeTextField)this, (Enum)Unit.SECONDS));
        this.time.bind((ObservableValue)this.seconds.add((ObservableNumberValue)this.minutes.multiply(60).add((ObservableNumberValue)this.hours.multiply(60))));
    }

    public ReadOnlyIntegerProperty secondsProperty() {
        return this.seconds.getReadOnlyProperty();
    }

    public int getSeconds() {
        return this.seconds.get();
    }

    public ReadOnlyIntegerProperty hoursProperty() {
        return this.hours.getReadOnlyProperty();
    }

    public int getHours() {
        return this.hours.get();
    }

    public ReadOnlyIntegerProperty minutesProperty() {
        return this.minutes.getReadOnlyProperty();
    }

    public int getMinutes() {
        return this.minutes.get();
    }

    @Override
    protected boolean validate(String time) {
        if (!this.timePattern.matcher(time).matches()) {
            return false;
        }
        String[] tokens = time.split(":");
        assert (tokens.length == 3);
        try {
            int hours = Integer.parseInt(tokens[0]);
            int mins = Integer.parseInt(tokens[1]);
            int secs = Integer.parseInt(tokens[2]);
            if (hours < 0 || hours > 23) {
                return false;
            }
            if (mins < 0 || mins > 59) {
                return false;
            }
            return secs >= 0 && secs <= 59;
        }
        catch (NumberFormatException nfe) {
            assert (false);
            return false;
        }
    }

    static enum Unit {
        HOURS,
        MINUTES,
        SECONDS;

    }
}

