/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.controls.table;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.Pane;
import javafx.util.Pair;

public class KeyValueTableView<K, V>
extends TableView<Pair<K, V>> {
    public static final float MAX_WIDTH = 5000.0f;
    public static final float PREF_WIDTH = 80.0f;
    public static final float MIN_WIDTH = 0.0f;
    private ObservableList<Pair<K, V>> allItems;
    private ObservableList<K> skippedKeys;
    private Double keyMaxWidth;
    private Double valueMaxWidth;
    private Double keyPrefWidth;
    private Double valuePrefWidth;
    private Double keyMinWidth;
    private Double valueMinWidth;
    private TableColumn<Pair<K, V>, String> keyColumn;
    private TableColumn<Pair<K, V>, String> valueColumn;

    public KeyValueTableView(ObservableList<Pair<K, V>> items, ObservableList<K> skipKeys, Double keyMaxWidth, Double valueMaxWidth) {
        super(items);
        this.initTable();
        this.initCells();
        this.allItems = items;
        this.skippedKeys = skipKeys;
        this.setKeyMaxWidth(keyMaxWidth == null ? Double.MIN_VALUE : keyMaxWidth);
        this.setValueMaxWidth(valueMaxWidth == null ? Double.MIN_VALUE : valueMaxWidth);
        this.filterItems();
    }

    public KeyValueTableView(List<Pair<K, V>> items, List<K> skipKeys) {
        this(FXCollections.observableArrayList(items), FXCollections.observableArrayList(skipKeys), null, null);
    }

    public KeyValueTableView(ObservableList<Pair<K, V>> items, ObservableList<K> skipKeys) {
        this(items, skipKeys, null, null);
    }

    public KeyValueTableView(ObservableList<Pair<K, V>> items) {
        this(items, FXCollections.observableArrayList(new ArrayList()), null, null);
    }

    public KeyValueTableView(List<Pair<K, V>> items) {
        this(FXCollections.observableArrayList(items), FXCollections.observableArrayList(new ArrayList()), null, null);
    }

    public KeyValueTableView() {
        this(FXCollections.observableArrayList(new ArrayList()));
    }

    public ObservableList<K> getSkippedKeys() {
        return this.skippedKeys;
    }

    public ObservableList<Pair<K, V>> getAllItems() {
        return this.allItems;
    }

    public Double getKeyMaxWidth() {
        return this.keyMaxWidth;
    }

    public Double getValueMaxWidth() {
        return this.valueMaxWidth;
    }

    public Double getValuePrefWidth() {
        return this.valuePrefWidth;
    }

    public Double getKeyPrefWidth() {
        return this.keyPrefWidth;
    }

    public Double getValueMinWidth() {
        return this.valueMinWidth;
    }

    public Double getKeyMinWidth() {
        return this.keyMinWidth;
    }

    public void setSkippedKeys(ObservableList<K> skippedKeys) {
        this.skippedKeys = skippedKeys;
        this.filterItems();
    }

    public void setValuePrefWidth(Double valuePrefWidth) {
        this.valuePrefWidth = valuePrefWidth;
        if (valuePrefWidth != Double.MIN_VALUE) {
            this.valueColumn.setPrefWidth(valuePrefWidth.doubleValue());
        } else {
            this.valueColumn.setPrefWidth(80.0);
        }
        this.setResizePolicy();
    }

    public void setKeyPrefWidth(Double keyPrefWidth) {
        this.keyPrefWidth = keyPrefWidth;
        if (keyPrefWidth != Double.MIN_VALUE) {
            this.keyColumn.setPrefWidth(keyPrefWidth.doubleValue());
        } else {
            this.keyColumn.setPrefWidth(80.0);
        }
        this.setResizePolicy();
    }

    public void setValueMinWidth(Double valueMinWidth) {
        this.valueMinWidth = this.valuePrefWidth;
        if (valueMinWidth != Double.MIN_VALUE) {
            this.valueColumn.setMinWidth(valueMinWidth.doubleValue());
        } else {
            this.valueColumn.setMinWidth(0.0);
        }
        this.setResizePolicy();
    }

    public void setKeyMinWidth(Double keyMinWidth) {
        this.keyMinWidth = this.keyPrefWidth;
        if (keyMinWidth != Double.MIN_VALUE) {
            this.keyColumn.setMinWidth(keyMinWidth.doubleValue());
        } else {
            this.keyColumn.setMinWidth(0.0);
        }
        this.setResizePolicy();
    }

    public void setKeyMaxWidth(Double keyMaxWidth) {
        this.keyMaxWidth = keyMaxWidth;
        if (keyMaxWidth != Double.MIN_VALUE) {
            this.keyColumn.setMaxWidth(keyMaxWidth.doubleValue());
        } else {
            this.keyColumn.setMaxWidth(5000.0);
        }
        this.setResizePolicy();
    }

    public void setValueMaxWidth(Double valueMaxWidth) {
        this.valueMaxWidth = valueMaxWidth;
        if (valueMaxWidth != Double.MIN_VALUE) {
            this.valueColumn.setMaxWidth(this.keyMaxWidth.doubleValue());
        } else {
            this.valueColumn.setMaxWidth(5000.0);
        }
        this.setResizePolicy();
    }

    public void setAllItems(ObservableList<Pair<K, V>> allItems) {
        this.allItems = allItems;
        this.filterItems();
    }

    public void renderItems() {
        this.filterItems();
    }

    private void filterItems() {
        if (this.skippedKeys.size() == 0) {
            this.setItems(this.allItems);
        } else {
            this.setItems((ObservableList)this.allItems.filtered(filter -> !this.skippedKeys.contains(filter.getKey())));
        }
    }

    private void setResizePolicy() {
        if (this.valueMaxWidth == null || this.keyMaxWidth == null || this.valueMinWidth == null || this.keyMinWidth == null) {
            this.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        } else {
            this.setColumnResizePolicy(TableView.UNCONSTRAINED_RESIZE_POLICY);
        }
    }

    private void initTable() {
        this.widthProperty().addListener((ov, t, t1) -> {
            Pane header = (Pane)this.lookup("TableHeaderRow");
            if (header != null && header.isVisible()) {
                header.setMaxHeight(3.0);
                header.setMinHeight(3.0);
                header.setPrefHeight(3.0);
            }
        });
        this.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
    }

    private void initCells() {
        this.keyColumn = new TableColumn();
        this.keyColumn.setCellValueFactory(cell -> new SimpleStringProperty(((Pair)cell.getValue()).getKey().toString()));
        this.valueColumn = new TableColumn();
        this.valueColumn.setCellValueFactory(cell -> new SimpleStringProperty(((Pair)cell.getValue()).getValue().toString()));
        this.getColumns().addAll((Object[])new TableColumn[]{this.keyColumn, this.valueColumn});
    }
}

