/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.controls.combobox;

import com.sun.javafx.scene.control.skin.ComboBoxListViewSkin;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.scene.control.ComboBox;
import javafx.scene.control.IndexRange;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class AutoCompleteComboBox<T>
extends ComboBox<T> {
    private AutoCompleteComboBoxListener<T> autoCompleteComboBoxListener = new AutoCompleteComboBoxListener(this);

    public AutoCompleteComboBox(ObservableList<T> items) {
        super(items);
    }

    private class AutoCompleteComboBoxListener<T> {
        private ComboBox<T> comboBox;
        private StringBuilder stringBuilder;
        private int lastLength;

        public AutoCompleteComboBoxListener(ComboBox<T> comboBox) {
            this.comboBox = comboBox;
            this.stringBuilder = new StringBuilder();
            this.comboBox.setEditable(true);
            this.comboBox.setOnKeyReleased(event -> {
                if (this.lastLength != comboBox.getEditor().getLength() - comboBox.getEditor().getSelectedText().length()) {
                    this.lastLength = comboBox.getEditor().getLength() - comboBox.getEditor().getSelectedText().length();
                }
                if (event.isControlDown() || event.getCode() == KeyCode.BACK_SPACE || event.getCode() == KeyCode.RIGHT || event.getCode() == KeyCode.LEFT || event.getCode() == KeyCode.DELETE || event.getCode() == KeyCode.HOME || event.getCode() == KeyCode.END || event.getCode() == KeyCode.TAB) {
                    return;
                }
                if (event.getCode().equals((Object)KeyCode.DOWN)) {
                    comboBox.show();
                    return;
                }
                IndexRange ir = comboBox.getEditor().getSelection();
                this.stringBuilder.delete(0, this.stringBuilder.length());
                this.stringBuilder.append(comboBox.getEditor().getText());
                try {
                    this.stringBuilder.delete(ir.getStart(), this.stringBuilder.length());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ObservableList items = comboBox.getItems();
                for (int i = 0; i < items.size(); ++i) {
                    if (items.get(i) == null || comboBox.getEditor().getText() == null || !items.get(i).toString().toLowerCase().startsWith(comboBox.getEditor().getText().toLowerCase())) continue;
                    try {
                        comboBox.getEditor().setText(this.stringBuilder.toString() + items.get(i).toString().substring(this.stringBuilder.toString().length()));
                        comboBox.setValue(items.get(i));
                        comboBox.getSelectionModel().select(i);
                    }
                    catch (Exception e) {
                        comboBox.getEditor().setText(this.stringBuilder.toString());
                    }
                    comboBox.getEditor().positionCaret(this.stringBuilder.toString().length());
                    comboBox.getEditor().selectEnd();
                    break;
                }
            });
            this.comboBox.getEditor().focusedProperty().addListener((observable, oldValue, newValue) -> {
                if (!newValue.booleanValue()) {
                    this.lastLength = 0;
                    this.stringBuilder.delete(0, this.stringBuilder.length());
                    this.selectClosestResultBasedOnTextFieldValue(false, false);
                }
            });
            this.comboBox.setOnMouseClicked(event -> this.selectClosestResultBasedOnTextFieldValue(true, true));
        }

        private void selectClosestResultBasedOnTextFieldValue(boolean affect, boolean inFocus) {
            ObservableList items = this.comboBox.getItems();
            boolean found = false;
            for (int i = 0; i < items.size(); ++i) {
                if (items.get(i) == null || this.comboBox.getEditor().getText() == null || !this.comboBox.getEditor().getText().toLowerCase().equals(items.get(i).toString().toLowerCase())) continue;
                try {
                    ListView lv = ((ComboBoxListViewSkin)this.comboBox.getSkin()).getListView();
                    lv.getSelectionModel().clearAndSelect(i);
                    lv.scrollTo(lv.getSelectionModel().getSelectedIndex());
                    found = true;
                    break;
                }
                catch (Exception lv) {
                    // empty catch block
                }
            }
            String s = this.comboBox.getEditor().getText();
            if (!found && affect) {
                this.comboBox.getSelectionModel().clearSelection();
                this.comboBox.getEditor().setText(s);
                this.comboBox.getEditor().end();
            }
            if (!found) {
                this.comboBox.getEditor().setText(null);
                this.comboBox.getSelectionModel().select(null);
                this.comboBox.setValue(null);
            }
            if (!inFocus && this.comboBox.getEditor().getText() != null && this.comboBox.getEditor().getText().trim().length() > 0) {
                KeyEvent ke = new KeyEvent(KeyEvent.KEY_RELEASED, KeyCode.ENTER.toString(), KeyCode.ENTER.toString(), KeyCode.ENTER, false, false, false, false);
                this.comboBox.fireEvent((Event)ke);
            }
        }
    }
}

