/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.controls.barcode.core;

import de.jonato.jfxc.controls.barcode.core.BarcodeEncoding;
import de.jonato.jfxc.controls.barcode.core.BarcodeFX;
import de.jonato.jfxc.controls.barcode.core.BarcodeSettings;
import javafx.scene.image.WritableImage;
import uk.org.okapibarcode.backend.Code3Of9;
import uk.org.okapibarcode.backend.CodeOne;
import uk.org.okapibarcode.backend.HumanReadableLocation;
import uk.org.okapibarcode.backend.MsiPlessey;

public class BarcodeFactory {
    public static BarcodeSettings getDefaultSettings() {
        BarcodeSettings barcodeSettings = new BarcodeSettings();
        barcodeSettings.setHumanReadableLocation(HumanReadableLocation.BOTTOM);
        barcodeSettings.setAztecEccModeEnabled(false);
        barcodeSettings.setChannelCodeChannels(0);
        barcodeSettings.setCodeOneVersion(CodeOne.Version.A);
        barcodeSettings.setCode39CheckDigit(Code3Of9.CheckDigit.MOD43);
        barcodeSettings.setDataMatrixSupressRectSymbolsinAutoMode(false);
        barcodeSettings.setQrEccModeEnabled(false);
        barcodeSettings.setDataMatrixSymbolSize(0);
        barcodeSettings.setDatabarColumns(0);
        barcodeSettings.setGridMatrixEccModeEnabled(false);
        barcodeSettings.setMsiPlesseyCheckDigit(MsiPlessey.CheckDigit.MOD10);
        return barcodeSettings;
    }

    public static WritableImage getBarcodeImage(BarcodeEncoding encoding, String data) {
        BarcodeFX barcode = new BarcodeFX(encoding, data);
        return barcode.getImage();
    }
}

