/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.controls.barcode.core;

import de.jonato.jfxc.controls.barcode.core.BarcodeEncoding;
import de.jonato.jfxc.controls.barcode.core.BarcodeFactory;
import de.jonato.jfxc.controls.barcode.core.BarcodeSettings;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.WritableImage;
import javax.imageio.ImageIO;
import uk.org.okapibarcode.Settings;
import uk.org.okapibarcode.backend.AustraliaPost;
import uk.org.okapibarcode.backend.AztecCode;
import uk.org.okapibarcode.backend.AztecRune;
import uk.org.okapibarcode.backend.ChannelCode;
import uk.org.okapibarcode.backend.Codabar;
import uk.org.okapibarcode.backend.CodablockF;
import uk.org.okapibarcode.backend.Code11;
import uk.org.okapibarcode.backend.Code128;
import uk.org.okapibarcode.backend.Code16k;
import uk.org.okapibarcode.backend.Code2Of5;
import uk.org.okapibarcode.backend.Code32;
import uk.org.okapibarcode.backend.Code3Of9;
import uk.org.okapibarcode.backend.Code3Of9Extended;
import uk.org.okapibarcode.backend.Code49;
import uk.org.okapibarcode.backend.Code93;
import uk.org.okapibarcode.backend.CodeOne;
import uk.org.okapibarcode.backend.DataBar14;
import uk.org.okapibarcode.backend.DataBarExpanded;
import uk.org.okapibarcode.backend.DataBarLimited;
import uk.org.okapibarcode.backend.DataMatrix;
import uk.org.okapibarcode.backend.Ean;
import uk.org.okapibarcode.backend.GridMatrix;
import uk.org.okapibarcode.backend.JapanPost;
import uk.org.okapibarcode.backend.Logmars;
import uk.org.okapibarcode.backend.MaxiCode;
import uk.org.okapibarcode.backend.MicroQrCode;
import uk.org.okapibarcode.backend.MsiPlessey;
import uk.org.okapibarcode.backend.Nve18;
import uk.org.okapibarcode.backend.Pharmacode;
import uk.org.okapibarcode.backend.Pharmacode2Track;
import uk.org.okapibarcode.backend.Pharmazentralnummer;
import uk.org.okapibarcode.backend.Postnet;
import uk.org.okapibarcode.backend.QrCode;
import uk.org.okapibarcode.backend.RoyalMail4State;
import uk.org.okapibarcode.backend.Symbol;
import uk.org.okapibarcode.backend.Telepen;
import uk.org.okapibarcode.backend.Upc;
import uk.org.okapibarcode.backend.UspsOneCode;
import uk.org.okapibarcode.backend.UspsPackage;
import uk.org.okapibarcode.output.Java2DRenderer;
import uk.org.okapibarcode.output.PostScriptRenderer;
import uk.org.okapibarcode.output.SvgRenderer;

public class BarcodeFX {
    private BarcodeEncoding type;
    private Symbol barcode;
    private String content;
    private Integer zoom;
    private Integer border;
    private javafx.scene.paint.Color foreground;
    private javafx.scene.paint.Color background;
    private BarcodeSettings barcodeSettings;

    public BarcodeFX(BarcodeEncoding type, String content) {
        this(type, content, javafx.scene.paint.Color.web((String)"#ffffff"), javafx.scene.paint.Color.web((String)"#000000"), 4, 20, BarcodeFactory.getDefaultSettings());
    }

    public BarcodeFX(BarcodeEncoding type, String content, javafx.scene.paint.Color background, javafx.scene.paint.Color foreground) {
        this(type, content, background, foreground, 4, 20, BarcodeFactory.getDefaultSettings());
    }

    public BarcodeFX(BarcodeEncoding type, String content, javafx.scene.paint.Color background, javafx.scene.paint.Color foreground, int zoom, int border, BarcodeSettings barcodeSettings) {
        this.type = type;
        this.setBarcodeSettings(barcodeSettings);
        this.setContent(content);
        this.setBackground(background);
        this.setForeground(foreground);
        this.setZoom(zoom);
        this.setBorder(border);
    }

    public WritableImage getImage() {
        Settings s = new Settings();
        Color paper = this.fxToAWTColor(this.background);
        Color ink = this.fxToAWTColor(this.foreground);
        BufferedImage image = new BufferedImage(this.barcode.getWidth() * this.zoom + 2 * this.border, this.barcode.getHeight() * this.zoom + 2 * this.border, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.fillRect(0, 0, this.barcode.getWidth() * this.zoom + 2 * this.border, this.barcode.getHeight() * this.zoom + 2 * this.border);
        Java2DRenderer renderer = new Java2DRenderer(g2d, (double)this.zoom.intValue(), this.border.intValue(), paper, ink);
        renderer.render(this.barcode);
        return SwingFXUtils.toFXImage((BufferedImage)image, null);
    }

    public void saveAsSVG(String file) throws IOException {
        Color paper = this.fxToAWTColor(this.background);
        Color ink = this.fxToAWTColor(this.foreground);
        SvgRenderer svg = new SvgRenderer((OutputStream)new FileOutputStream(file), (double)this.zoom.intValue(), this.border.intValue(), paper, ink);
        svg.render(this.barcode);
    }

    public void saveAsEPS(String file) throws IOException {
        Color paper = this.fxToAWTColor(this.background);
        Color ink = this.fxToAWTColor(this.foreground);
        PostScriptRenderer eps = new PostScriptRenderer((OutputStream)new FileOutputStream(file), (double)this.zoom.intValue(), this.border.intValue(), paper, ink);
        eps.render(this.barcode);
    }

    public void saveAsPNG(String file) throws IOException {
        this.save(file, "png");
    }

    public void saveAsJPG(String file) throws IOException {
        this.save(file, "jpg");
    }

    public void saveAsBMP(String file) throws IOException {
        this.save(file, "bmp");
    }

    public void saveAsGIF(String file) throws IOException {
        this.save(file, "gif");
    }

    public File saveTemp(String tempName, String extension) throws IOException {
        File file = File.createTempFile(tempName, "." + extension);
        this.save(file, extension);
        return file;
    }

    private void save(String file, String extension) throws IOException {
        this.save(new File(file), extension);
    }

    private void save(File file, String extension) throws IOException {
        Color paper = this.fxToAWTColor(this.background);
        Color ink = this.fxToAWTColor(this.foreground);
        BufferedImage image = new BufferedImage(this.barcode.getWidth() * this.zoom + 2 * this.border, this.barcode.getHeight() * this.zoom + 2 * this.border, 1);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(paper);
        g2d.fillRect(0, 0, this.barcode.getWidth() * this.zoom + 2 * this.border, this.barcode.getHeight() * this.zoom + 2 * this.border);
        Java2DRenderer renderer = new Java2DRenderer(g2d, (double)this.zoom.intValue(), this.border.intValue(), paper, ink);
        renderer.render(this.barcode);
        ImageIO.write((RenderedImage)image, extension, file);
    }

    public Symbol getBarcode() {
        return this.barcode;
    }

    public void setBarcode(Symbol barcode) {
        this.barcode = barcode;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.barcode.setContent(content);
    }

    public Integer getZoom() {
        return this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    public Integer getBorder() {
        return this.border;
    }

    public void setBorder(Integer border) {
        this.border = border;
    }

    public javafx.scene.paint.Color getForeground() {
        return this.foreground;
    }

    public void setForeground(javafx.scene.paint.Color foreground) {
        this.foreground = foreground;
    }

    public javafx.scene.paint.Color getBackground() {
        return this.background;
    }

    public void setBackground(javafx.scene.paint.Color background) {
        this.background = background;
    }

    public BarcodeSettings getBarcodeSettings() {
        return this.barcodeSettings;
    }

    public void setBarcodeSettings(BarcodeSettings barcodeSettings) {
        this.barcodeSettings = barcodeSettings;
        this.initType();
    }

    private Color fxToAWTColor(javafx.scene.paint.Color color) {
        int r = (int)color.getRed() * 255;
        int g = (int)color.getGreen() * 255;
        int b = (int)color.getBlue() * 255;
        int rgb = (r << 16) + (g << 8) + b;
        return new Color(rgb);
    }

    private void initType() {
        switch (this.type) {
            case CHANNEL_CODE: {
                ChannelCode channelCode = new ChannelCode();
                channelCode.setNumberOfChannels(this.barcodeSettings.getChannelCodeChannels().intValue());
                this.barcode = channelCode;
                break;
            }
            case CODABAR: {
                Codabar codabar = new Codabar();
                this.barcode = codabar;
                break;
            }
            case CODE_11: {
                Code11 code11 = new Code11();
                this.barcode = code11;
                break;
            }
            case CODE_2OF5_DEFAULT: {
                Code2Of5 c25 = new Code2Of5();
                this.barcode = c25;
                break;
            }
            case CODE_2OF5_IATA: {
                Code2Of5 c25iata = new Code2Of5();
                c25iata.setIATAMode();
                this.barcode = c25iata;
                break;
            }
            case CODE_2OF5_INDUSTRIAL: {
                Code2Of5 c25ind = new Code2Of5();
                c25ind.setIndustrialMode();
                this.barcode = c25ind;
                break;
            }
            case CODE_2OF5_INTERLEAVED: {
                Code2Of5 c25inter = new Code2Of5();
                c25inter.setInterleavedMode();
                this.barcode = c25inter;
                break;
            }
            case CODE_2OF5_DATA_LOGIC: {
                Code2Of5 c25logic = new Code2Of5();
                c25logic.setDataLogicMode();
                this.barcode = c25logic;
                break;
            }
            case CODE_2OF5_ITF_14: {
                Code2Of5 itf14 = new Code2Of5();
                itf14.setITF14Mode();
                this.barcode = itf14;
                break;
            }
            case CODE_CODE39_DEFAULT: {
                Code3Of9 code3of9 = new Code3Of9();
                switch (this.barcodeSettings.getCode39CheckDigit().ordinal()) {
                    case 0: {
                        code3of9.setCheckDigit(Code3Of9.CheckDigit.NONE);
                        break;
                    }
                    case 1: {
                        code3of9.setCheckDigit(Code3Of9.CheckDigit.MOD43);
                    }
                }
                this.barcode = code3of9;
                break;
            }
            case CODE_CODE39_EXTENDED: {
                Code3Of9Extended code3of9ext = new Code3Of9Extended();
                switch (this.barcodeSettings.getCode39CheckDigit().ordinal()) {
                    case 0: {
                        code3of9ext.setCheckDigit(Code3Of9Extended.CheckDigit.NONE);
                        break;
                    }
                    case 1: {
                        code3of9ext.setCheckDigit(Code3Of9Extended.CheckDigit.MOD43);
                    }
                }
                this.barcode = code3of9ext;
                break;
            }
            case CODE_93: {
                Code93 code93 = new Code93();
                this.barcode = code93;
                break;
            }
            case CODE_CODE39_LOGMARS: {
                Logmars logmars = new Logmars();
                this.barcode = logmars;
                break;
            }
            case CODE_CODE128: {
                Code128 code128 = new Code128();
                code128.unsetCc();
                this.barcode = code128;
                break;
            }
            case CODE_CODE128_NVE18: {
                Nve18 nve18 = new Nve18();
                this.barcode = nve18;
                break;
            }
            case EAN8: {
                Ean ean8 = new Ean();
                ean8.setMode(Ean.Mode.EAN8);
                this.barcode = ean8;
                break;
            }
            case EAN13: {
                Ean ean13 = new Ean();
                ean13.setMode(Ean.Mode.EAN13);
                this.barcode = ean13;
                break;
            }
            case MSI_PLESSEY: {
                MsiPlessey msiPlessey = new MsiPlessey();
                switch (this.barcodeSettings.getMsiPlesseyCheckDigit().ordinal()) {
                    case 0: {
                        msiPlessey.setCheckDigit(MsiPlessey.CheckDigit.NONE);
                        break;
                    }
                    case 1: {
                        msiPlessey.setCheckDigit(MsiPlessey.CheckDigit.MOD10);
                        break;
                    }
                    case 2: {
                        msiPlessey.setCheckDigit(MsiPlessey.CheckDigit.MOD10_MOD10);
                        break;
                    }
                    case 3: {
                        msiPlessey.setCheckDigit(MsiPlessey.CheckDigit.MOD11);
                        break;
                    }
                    case 4: {
                        msiPlessey.setCheckDigit(MsiPlessey.CheckDigit.MOD11_MOD10);
                    }
                }
                this.barcode = msiPlessey;
                break;
            }
            case TELEPEN_ALPHA: {
                Telepen telepen = new Telepen();
                telepen.setNormalMode();
                this.barcode = telepen;
                break;
            }
            case TELEPEN_NUMERIC: {
                Telepen telepenNum = new Telepen();
                telepenNum.setNumericMode();
                this.barcode = telepenNum;
                break;
            }
            case UPC_A: {
                Upc upca = new Upc();
                upca.setMode(Upc.Mode.UPCA);
                upca.unsetLinkageFlag();
                this.barcode = upca;
                break;
            }
            case UPC_E: {
                Upc upce = new Upc();
                upce.setMode(Upc.Mode.UPCE);
                upce.unsetLinkageFlag();
                this.barcode = upce;
                break;
            }
            case STACKED_CODABLOCK_F: {
                CodablockF codablockF = new CodablockF();
                this.barcode = codablockF;
                break;
            }
            case STACKED_CODE_16K: {
                Code16k code16k = new Code16k();
                this.barcode = code16k;
                break;
            }
            case STACKED_CODE_49: {
                Code49 code49 = new Code49();
                this.barcode = code49;
                break;
            }
            case AZTEC_CODE: {
                AztecCode aztecCode = new AztecCode();
                if (this.barcodeSettings.isAztecEccModeEnabled()) {
                    aztecCode.setPreferredEccLevel(this.barcodeSettings.getAztecCodeEcc().ordinal() + 1);
                }
                this.barcode = aztecCode;
                break;
            }
            case AZTEC_RUNES: {
                AztecRune aztecRune = new AztecRune();
                this.barcode = aztecRune;
                break;
            }
            case DATA_MATRIX: {
                DataMatrix dataMatrix = new DataMatrix();
                dataMatrix.setDataType(Symbol.DataType.HIBC);
                dataMatrix.setPreferredSize(this.barcodeSettings.getDataMatrixSymbolSize().intValue());
                dataMatrix.forceSquare(this.barcodeSettings.isDataMatrixSupressRectSymbolsinAutoMode());
                this.barcode = dataMatrix;
                break;
            }
            case CODE_ONE: {
                CodeOne codeOne = new CodeOne();
                switch (this.barcodeSettings.getCodeOneVersion().ordinal()) {
                    case 0: {
                        codeOne.setPreferredVersion(CodeOne.Version.NONE);
                        break;
                    }
                    case 1: {
                        codeOne.setPreferredVersion(CodeOne.Version.A);
                        break;
                    }
                    case 2: {
                        codeOne.setPreferredVersion(CodeOne.Version.B);
                        break;
                    }
                    case 3: {
                        codeOne.setPreferredVersion(CodeOne.Version.C);
                        break;
                    }
                    case 4: {
                        codeOne.setPreferredVersion(CodeOne.Version.D);
                        break;
                    }
                    case 5: {
                        codeOne.setPreferredVersion(CodeOne.Version.E);
                        break;
                    }
                    case 6: {
                        codeOne.setPreferredVersion(CodeOne.Version.F);
                        break;
                    }
                    case 7: {
                        codeOne.setPreferredVersion(CodeOne.Version.G);
                        break;
                    }
                    case 8: {
                        codeOne.setPreferredVersion(CodeOne.Version.H);
                        break;
                    }
                    case 9: {
                        codeOne.setPreferredVersion(CodeOne.Version.S);
                        break;
                    }
                    case 10: {
                        codeOne.setPreferredVersion(CodeOne.Version.T);
                    }
                }
                this.barcode = codeOne;
            }
            case GRID_MATRIX: {
                GridMatrix gridMatrix = new GridMatrix();
                if (this.barcodeSettings.isGridMatrixEccModeEnabled()) {
                    gridMatrix.setPreferredEccLevel(this.barcodeSettings.getGridMatrixCodeEcc().ordinal());
                }
                this.barcode = gridMatrix;
                break;
            }
            case MAXI_CODE: {
                MaxiCode maxiCode = new MaxiCode();
                this.barcode = maxiCode;
                break;
            }
            case QR_CODE: {
                QrCode qrCode = new QrCode();
                if (this.barcodeSettings.isQrEccModeEnabled()) {
                    switch (this.barcodeSettings.getQrEccMode().ordinal()) {
                        case 0: {
                            qrCode.setEccMode(QrCode.EccMode.L);
                            break;
                        }
                        case 1: {
                            qrCode.setEccMode(QrCode.EccMode.M);
                            break;
                        }
                        case 2: {
                            qrCode.setEccMode(QrCode.EccMode.Q);
                            break;
                        }
                        case 3: {
                            qrCode.setEccMode(QrCode.EccMode.H);
                        }
                    }
                }
                this.barcode = qrCode;
                break;
            }
            case QR_CODE_MICRO: {
                MicroQrCode microQrCode = new MicroQrCode();
                if (this.barcodeSettings.isQrEccModeEnabled()) {
                    switch (this.barcodeSettings.getQrEccMode().ordinal()) {
                        case 0: {
                            microQrCode.setEccMode(MicroQrCode.EccMode.L);
                            break;
                        }
                        case 1: {
                            microQrCode.setEccMode(MicroQrCode.EccMode.M);
                            break;
                        }
                        case 2: {
                            microQrCode.setEccMode(MicroQrCode.EccMode.Q);
                            break;
                        }
                        case 3: {
                            microQrCode.setEccMode(MicroQrCode.EccMode.H);
                        }
                    }
                }
                this.barcode = microQrCode;
                break;
            }
            case GS1_DATABAR_OMNIDIRECTIONAL: {
                DataBar14 dataBar14 = new DataBar14();
                dataBar14.setLinearMode();
                this.barcode = dataBar14;
                break;
            }
            case GS1_DATABAR_STACKED: {
                DataBar14 dataBar14s = new DataBar14();
                dataBar14s.setStackedMode();
                this.barcode = dataBar14s;
                break;
            }
            case GS1_DATABAR_STACKED_OMNIDIRECTIONAL: {
                DataBar14 dataBar14so = new DataBar14();
                dataBar14so.setOmnidirectionalMode();
                this.barcode = dataBar14so;
                break;
            }
            case GS1_DATABAR_LIMITED: {
                DataBarLimited dataBarLimited = new DataBarLimited();
                this.barcode = dataBarLimited;
                break;
            }
            case GS1_DATABAR_EXPANDED_OMNIDIRECTIONAL: {
                DataBarExpanded dataBarE = new DataBarExpanded();
                dataBarE.setNotStacked();
                this.barcode = dataBarE;
                break;
            }
            case GS1_DATABAR_EXPANDED_STACKED_OMNIDIRECTIONAL: {
                DataBarExpanded dataBarES = new DataBarExpanded();
                dataBarES.setNoOfColumns(this.barcodeSettings.getDatabarColumns().intValue());
                dataBarES.setStacked();
                this.barcode = dataBarES;
                break;
            }
            case POSTAL_AUSPOST: {
                AustraliaPost auPost = new AustraliaPost();
                auPost.setPostMode();
                this.barcode = auPost;
            }
            case POSTAL_AUSPOST_REPLY: {
                AustraliaPost auReply = new AustraliaPost();
                auReply.setReplyMode();
                this.barcode = auReply;
            }
            case POSTAL_DEUTSCHE_POST_LEITCODE: {
                Code2Of5 dpLeit = new Code2Of5();
                dpLeit.setDPLeitMode();
                this.barcode = dpLeit;
                break;
            }
            case POSTAL_DEUTSCHE_POST_IDENTCODE: {
                Code2Of5 dpIdent = new Code2Of5();
                dpIdent.setDPIdentMode();
                this.barcode = dpIdent;
                break;
            }
            case POSTAL_JAPAN_POST: {
                JapanPost japanPost = new JapanPost();
                this.barcode = japanPost;
                break;
            }
            case POSTAL_ROYAL_MAIL: {
                RoyalMail4State royalMail = new RoyalMail4State();
                this.barcode = royalMail;
                break;
            }
            case POSTAL_USPS_INTELLIGENT_MAIL: {
                UspsOneCode uspsOneCode = new UspsOneCode();
                this.barcode = uspsOneCode;
                break;
            }
            case POSTAL_USPS_IM_PACKAGE_BC: {
                UspsPackage uspsPackage = new UspsPackage();
                this.barcode = uspsPackage;
                break;
            }
            case POSTAL_BRAZIL_CEPNET: 
            case POSTAL_USPS_POSTNET: {
                Postnet postnet = new Postnet();
                postnet.setPostnet();
                this.barcode = postnet;
                break;
            }
            case POSTAL_USPS_PLANET: {
                Postnet planet = new Postnet();
                planet.setPlanet();
                this.barcode = planet;
                break;
            }
            case MEDICAL_CODE32: {
                Code32 code32 = new Code32();
                this.barcode = code32;
                break;
            }
            case MEDICAL_HIBC_AZTEC: {
                AztecCode aztecCodemed = new AztecCode();
                aztecCodemed.setDataType(Symbol.DataType.HIBC);
                if (this.barcodeSettings.isAztecEccModeEnabled()) {
                    aztecCodemed.setPreferredEccLevel(this.barcodeSettings.getAztecCodeEcc().ordinal() + 1);
                }
                this.barcode = aztecCodemed;
                break;
            }
            case MEDICAL_HIBC_CODABLOCK_F: {
                CodablockF codablockFmed = new CodablockF();
                codablockFmed.setDataType(Symbol.DataType.HIBC);
                this.barcode = codablockFmed;
                break;
            }
            case MEDICAL_HIBC_CODE39: {
                Code3Of9 code3of9med = new Code3Of9();
                code3of9med.setDataType(Symbol.DataType.HIBC);
                switch (this.barcodeSettings.getCode39CheckDigit().ordinal()) {
                    case 0: {
                        code3of9med.setCheckDigit(Code3Of9.CheckDigit.NONE);
                        break;
                    }
                    case 1: {
                        code3of9med.setCheckDigit(Code3Of9.CheckDigit.MOD43);
                    }
                }
                this.barcode = code3of9med;
                break;
            }
            case MEDICAL_HIBC_CODE128: {
                Code128 hibcCode128 = new Code128();
                hibcCode128.unsetCc();
                hibcCode128.setDataType(Symbol.DataType.HIBC);
                this.barcode = hibcCode128;
                break;
            }
            case MEDICAL_DATA_MATRIX: {
                DataMatrix dataMatrixmed = new DataMatrix();
                dataMatrixmed.setDataType(Symbol.DataType.HIBC);
                dataMatrixmed.setPreferredSize(this.barcodeSettings.getDataMatrixSymbolSize().intValue());
                dataMatrixmed.forceSquare(this.barcodeSettings.isDataMatrixSupressRectSymbolsinAutoMode());
                this.barcode = dataMatrixmed;
                break;
            }
            case MEDICAL_QR_CODE: {
                QrCode qrCodeHibc = new QrCode();
                qrCodeHibc.setDataType(Symbol.DataType.HIBC);
                if (this.barcodeSettings.isQrEccModeEnabled()) {
                    switch (this.barcodeSettings.getQrEccMode().ordinal()) {
                        case 0: {
                            qrCodeHibc.setEccMode(QrCode.EccMode.L);
                            break;
                        }
                        case 1: {
                            qrCodeHibc.setEccMode(QrCode.EccMode.M);
                            break;
                        }
                        case 2: {
                            qrCodeHibc.setEccMode(QrCode.EccMode.Q);
                            break;
                        }
                        case 3: {
                            qrCodeHibc.setEccMode(QrCode.EccMode.H);
                        }
                    }
                }
                this.barcode = qrCodeHibc;
                break;
            }
            case MEDICAL_PHARMACODE_ONE_TRACK: {
                Pharmacode pharmacode = new Pharmacode();
                this.barcode = pharmacode;
                break;
            }
            case MEDICAL_PHARMACODE_TWO_TRACK: {
                Pharmacode2Track pharmacode2t = new Pharmacode2Track();
                this.barcode = pharmacode2t;
                break;
            }
            case MEDICAL_PZN8: {
                Pharmazentralnummer pzn = new Pharmazentralnummer();
                this.barcode = pzn;
            }
        }
        if (this.barcode == null) {
            return;
        }
        this.barcode.setHumanReadableLocation(this.barcodeSettings.getHumanReadableLocation());
    }
}

