/*
 * Decompiled with CFR 0.152.
 */
package de.jonato.jfxc.controls.barcode;

import de.jonato.jfxc.controls.barcode.core.BarcodeEncoding;
import de.jonato.jfxc.controls.barcode.core.BarcodeFX;
import java.io.File;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.Map;
import javafx.beans.property.SimpleStringProperty;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class BarcodeView
extends ImageView {
    private SimpleStringProperty data;
    private BarcodeFX barcodeFX;

    public BarcodeView(BarcodeEncoding encoding, String value) {
        this.barcodeFX = new BarcodeFX(encoding, value);
        this.data = new SimpleStringProperty(value);
        this.data.addListener((observable, oldValue, newValue) -> {
            this.barcodeFX.setContent((String)newValue);
            this.setImage((Image)this.barcodeFX.getImage());
        });
        if (value.length() > 0) {
            this.setImage((Image)this.barcodeFX.getImage());
        }
        this.setSmooth(true);
        this.setPreserveRatio(true);
        VBox.setVgrow((Node)this, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        this.setOnDragDetected(event -> {
            Dragboard db = this.startDragAndDrop(TransferMode.COPY_OR_MOVE);
            ClipboardContent content = new ClipboardContent();
            try {
                File tmpFile = this.barcodeFX.saveTemp(LocalDateTime.now().toString(), "png");
                content.putFiles(Collections.singletonList(tmpFile));
                tmpFile.deleteOnExit();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            db.setContent((Map)content);
            event.consume();
        });
        this.setOnDragDone(me -> me.consume());
    }

    public String getData() {
        return this.data.get();
    }

    public SimpleStringProperty dataProperty() {
        return this.data;
    }

    public void setData(String data) {
        this.data.set(data);
    }

    public BarcodeFX getBarcodeFX() {
        return this.barcodeFX;
    }
}

