/*
 * Decompiled with CFR 0.152.
 */
package de.jonasbroeckmann.kzip;

import de.jonasbroeckmann.kzip.InternalKt;
import de.jonasbroeckmann.kzip.Zip;
import de.jonasbroeckmann.kzip.Zip_jvmKt;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.io.CoreKt;
import kotlinx.io.JvmCoreKt;
import kotlinx.io.RawSink;
import kotlinx.io.RawSource;
import kotlinx.io.Sink;
import kotlinx.io.SinksJvmKt;
import kotlinx.io.Source;
import kotlinx.io.SourcesKt;
import kotlinx.io.files.FileSystem;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001:\u00014B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ)\u0010\"\u001a\u00020#2\u0006\u0010\"\u001a\u00020\u00032\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020#0%\u00a2\u0006\u0002\b'H\u0016J)\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020\u00172\u0017\u0010$\u001a\u0013\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020#0%\u00a2\u0006\u0002\b'H\u0016J\u0016\u0010)\u001a\u00020#2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00170\u001bH\u0016J\u0016\u0010+\u001a\u00020#2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00030\u001bH\u0016J\u0018\u0010-\u001a\u00020#2\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010.\u001a\u00020/H\u0016J\u0018\u00100\u001a\u00020#2\u0006\u0010\"\u001a\u00020\u00032\u0006\u00101\u001a\u00020\u0003H\u0016J\u0010\u00102\u001a\u00020#2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\b\u00103\u001a\u00020#H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R)\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c0\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001f\u00a8\u00065"}, d2={"Lde/jonasbroeckmann/kzip/JavaZip;", "Lde/jonasbroeckmann/kzip/Zip;", "zipFile", "Lkotlinx/io/files/Path;", "mode", "Lde/jonasbroeckmann/kzip/Zip$Mode;", "level", "Lde/jonasbroeckmann/kzip/Zip$CompressionLevel;", "<init>", "(Lkotlinx/io/files/Path;Lde/jonasbroeckmann/kzip/Zip$Mode;Lde/jonasbroeckmann/kzip/Zip$CompressionLevel;)V", "getMode", "()Lde/jonasbroeckmann/kzip/Zip$Mode;", "_zip", "Ljava/util/zip/ZipFile;", "zip", "getZip", "()Ljava/util/zip/ZipFile;", "_zos", "Ljava/util/zip/ZipOutputStream;", "zos", "getZos", "()Ljava/util/zip/ZipOutputStream;", "numberOfEntries", "", "getNumberOfEntries", "()I", "entries", "", "Ljava/util/zip/ZipEntry;", "kotlin.jvm.PlatformType", "getEntries", "()Ljava/util/List;", "entries$delegate", "Lkotlin/Lazy;", "entry", "", "block", "Lkotlin/Function1;", "Lde/jonasbroeckmann/kzip/Zip$Entry;", "Lkotlin/ExtensionFunctionType;", "index", "deleteEntriesByIndex", "indices", "deleteEntries", "paths", "entryFromSource", "data", "Lkotlinx/io/Source;", "entryFromPath", "file", "folderEntry", "close", "Entry", "kzip"})
@SourceDebugExtension(value={"SMAP\nZip.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Zip.jvm.kt\nde/jonasbroeckmann/kzip/JavaZip\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
final class JavaZip
implements Zip {
    @NotNull
    private final Path zipFile;
    @NotNull
    private final Zip.Mode mode;
    @NotNull
    private final Zip.CompressionLevel level;
    @Nullable
    private ZipFile _zip;
    @Nullable
    private ZipOutputStream _zos;
    @NotNull
    private final Lazy entries$delegate;

    public JavaZip(@NotNull Path zipFile, @NotNull Zip.Mode mode, @NotNull Zip.CompressionLevel level) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        this.zipFile = zipFile;
        this.mode = mode;
        this.level = level;
        this.entries$delegate = LazyKt.lazy(() -> JavaZip.entries_delegate$lambda$3(this));
    }

    @Override
    @NotNull
    public Zip.Mode getMode() {
        return this.mode;
    }

    private final ZipFile getZip() {
        InternalKt.requireReadable(this);
        ZipFile zipFile = this._zip;
        if (zipFile == null) {
            ZipFile zipFile2;
            ZipFile it = zipFile2 = new ZipFile(new File(this.zipFile.toString()));
            boolean bl = false;
            this._zip = it;
            zipFile = zipFile2;
        }
        return zipFile;
    }

    private final ZipOutputStream getZos() {
        InternalKt.requireWritable(this);
        ZipOutputStream zipOutputStream = this._zos;
        if (zipOutputStream == null) {
            ZipOutputStream zipOutputStream2;
            ZipOutputStream $this$_get_zos__u24lambda_u241 = zipOutputStream2 = new ZipOutputStream(SinksJvmKt.asOutputStream((Sink)CoreKt.buffered((RawSink)FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)this.zipFile, (boolean)false, (int)2, null))));
            boolean bl = false;
            $this$_get_zos__u24lambda_u241.setLevel(this.level.getZlibLevel());
            ZipOutputStream it = zipOutputStream2;
            boolean bl2 = false;
            this._zos = it;
            zipOutputStream = zipOutputStream2;
        }
        return zipOutputStream;
    }

    @Override
    public int getNumberOfEntries() {
        return Zip_jvmKt.access$orError(this.getZip().size());
    }

    private final List<ZipEntry> getEntries() {
        Lazy lazy = this.entries$delegate;
        return (List)lazy.getValue();
    }

    @Override
    public void entry(@NotNull Path entry, @NotNull Function1<? super Zip.Entry, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        String name = InternalKt.pathToEntryName(Zip.Companion, entry);
        ZipEntry zipEntry = this.getZip().getEntry(name);
        if (zipEntry == null) {
            throw new ZipException("Entry not found: " + name);
        }
        block.invoke((Object)new Entry(zipEntry));
    }

    @Override
    public void entry(int index, @NotNull Function1<? super Zip.Entry, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        ZipEntry zipEntry = this.getEntries().get(index);
        Intrinsics.checkNotNullExpressionValue((Object)zipEntry, (String)"get(...)");
        block.invoke((Object)new Entry(zipEntry));
    }

    @Override
    public void deleteEntriesByIndex(@NotNull List<Integer> indices) {
        Intrinsics.checkNotNullParameter(indices, (String)"indices");
        throw new UnsupportedOperationException("Deleting entries is not supported on JVM");
    }

    @Override
    public void deleteEntries(@NotNull List<Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        throw new UnsupportedOperationException("Deleting entries is not supported on JVM");
    }

    @Override
    public void entryFromSource(@NotNull Path entry, @NotNull Source data) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.getZos().putNextEntry(new ZipEntry(InternalKt.pathToEntryName(Zip.Companion, entry)));
        data.transferTo(JvmCoreKt.asSink((OutputStream)this.getZos()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void entryFromPath(@NotNull Path entry, @NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        InternalKt.requireFile(file);
        this.getZos().putNextEntry(new ZipEntry(InternalKt.pathToEntryName(Zip.Companion, entry)));
        AutoCloseable autoCloseable = (AutoCloseable)CoreKt.buffered((RawSource)FileSystemJvmKt.SystemFileSystem.source(file));
        Throwable throwable = null;
        try {
            Source it = (Source)autoCloseable;
            boolean bl = false;
            long l = it.transferTo(JvmCoreKt.asSink((OutputStream)this.getZos()));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    public void folderEntry(@NotNull Path entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.getZos().putNextEntry(new ZipEntry(InternalKt.pathToEntryName(Zip.Companion, entry) + "/"));
    }

    @Override
    public void close() {
        ZipOutputStream zipOutputStream = this._zos;
        if (zipOutputStream != null) {
            zipOutputStream.close();
        }
        this._zos = null;
        ZipFile zipFile = this._zip;
        if (zipFile != null) {
            zipFile.close();
        }
        this._zip = null;
    }

    private static final List entries_delegate$lambda$3(JavaZip this$0) {
        Enumeration<? extends ZipEntry> enumeration = this$0.getZip().entries();
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"entries(...)");
        ArrayList<? extends ZipEntry> arrayList = Collections.list(enumeration);
        Intrinsics.checkNotNullExpressionValue(arrayList, (String)"list(...)");
        return arrayList;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00078VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lde/jonasbroeckmann/kzip/JavaZip$Entry;", "Lde/jonasbroeckmann/kzip/Zip$Entry;", "entry", "Ljava/util/zip/ZipEntry;", "<init>", "(Lde/jonasbroeckmann/kzip/JavaZip;Ljava/util/zip/ZipEntry;)V", "path", "Lkotlinx/io/files/Path;", "getPath", "()Lkotlinx/io/files/Path;", "path$delegate", "Lkotlin/Lazy;", "isDirectory", "", "()Z", "uncompressedSize", "Lkotlin/ULong;", "getUncompressedSize-s-VKNKU", "()J", "compressedSize", "getCompressedSize-s-VKNKU", "crc32", "", "getCrc32", "readToSource", "Lkotlinx/io/Source;", "readToBytes", "", "readToPath", "", "kzip"})
    @SourceDebugExtension(value={"SMAP\nZip.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Zip.jvm.kt\nde/jonasbroeckmann/kzip/JavaZip$Entry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
    private final class Entry
    implements Zip.Entry {
        @NotNull
        private final ZipEntry entry;
        @NotNull
        private final Lazy path$delegate;

        public Entry(ZipEntry entry) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entry = entry;
            this.path$delegate = LazyKt.lazy(() -> Entry.path_delegate$lambda$0(this));
        }

        @Override
        @NotNull
        public Path getPath() {
            Lazy lazy = this.path$delegate;
            return (Path)lazy.getValue();
        }

        @Override
        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        @Override
        public long getUncompressedSize-s-VKNKU() {
            return Zip_jvmKt.access$orError(this.entry.getSize());
        }

        @Override
        public long getCompressedSize-s-VKNKU() {
            return Zip_jvmKt.access$orError(this.entry.getCompressedSize());
        }

        @Override
        public long getCrc32() {
            return this.entry.getCrc();
        }

        @Override
        @NotNull
        public Source readToSource() {
            InputStream inputStream = JavaZip.this.getZip().getInputStream(this.entry);
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            return CoreKt.buffered((RawSource)JvmCoreKt.asSource((InputStream)inputStream));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        public byte[] readToBytes() {
            byte[] byArray;
            AutoCloseable autoCloseable = (AutoCloseable)this.readToSource();
            Throwable throwable = null;
            try {
                Source it = (Source)autoCloseable;
                boolean bl = false;
                byArray = SourcesKt.readByteArray((Source)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void readToPath(@NotNull Path path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            AutoCloseable autoCloseable = (AutoCloseable)this.readToSource();
            Throwable throwable = null;
            try {
                long l;
                Source source = (Source)autoCloseable;
                boolean bl = false;
                AutoCloseable autoCloseable2 = (AutoCloseable)CoreKt.buffered((RawSink)FileSystem.sink$default((FileSystem)FileSystemJvmKt.SystemFileSystem, (Path)path, (boolean)false, (int)2, null));
                Throwable throwable2 = null;
                try {
                    Sink sink = (Sink)autoCloseable2;
                    boolean bl2 = false;
                    l = source.transferTo((RawSink)sink);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }

        private static final Path path_delegate$lambda$0(Entry this$0) {
            String string = this$0.entry.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            return InternalKt.entryNameToPath(Zip.Companion, string);
        }
    }
}

