/*
 * Decompiled with CFR 0.152.
 */
package de.jonasbroeckmann.kzip;

import de.jonasbroeckmann.kzip.Zip;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.io.files.FileMetadata;
import kotlinx.io.files.FileSystemJvmKt;
import kotlinx.io.files.Path;
import kotlinx.io.files.PathsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0014\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\u0007\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0014\u0010\b\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\t\u001a\u00020\u0003H\u0000\u001a\f\u0010\n\u001a\u00020\u000b*\u00020\fH\u0000\u001a\f\u0010\r\u001a\u00020\u000b*\u00020\fH\u0000\u001a\f\u0010\u000e\u001a\u00020\u000b*\u00020\u0006H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"ZipEntryNameSeparator", "", "pathToEntryName", "", "Lde/jonasbroeckmann/kzip/Zip$Companion;", "path", "Lkotlinx/io/files/Path;", "pathToFolderEntryName", "entryNameToPath", "name", "requireWritable", "", "Lde/jonasbroeckmann/kzip/Zip;", "requireReadable", "requireFile", "kzip"})
@SourceDebugExtension(value={"SMAP\nInternal.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Internal.kt\nde/jonasbroeckmann/kzip/InternalKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,43:1\n37#2:44\n36#2,3:45\n*S KotlinDebug\n*F\n+ 1 Internal.kt\nde/jonasbroeckmann/kzip/InternalKt\n*L\n26#1:44\n26#1:45,3\n*E\n"})
public final class InternalKt {
    private static final char ZipEntryNameSeparator = '/';

    @NotNull
    public static final String pathToEntryName(@NotNull Zip.Companion $this$pathToEntryName, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$pathToEntryName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (path.isAbsolute()) {
            throw new IllegalArgumentException("Path for zip entry must be relative: " + path);
        }
        Path path2 = path.getParent();
        if (path2 != null) {
            Path parent = path2;
            boolean bl = false;
            return InternalKt.pathToEntryName($this$pathToEntryName, parent) + "/" + path.getName();
        }
        return path.getName();
    }

    @NotNull
    public static final String pathToFolderEntryName(@NotNull Zip.Companion $this$pathToFolderEntryName, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$pathToFolderEntryName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return InternalKt.pathToEntryName($this$pathToFolderEntryName, path) + "/";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Path entryNameToPath(@NotNull Zip.Companion $this$entryNameToPath, @NotNull String name) {
        void $this$toTypedArray$iv;
        void it;
        Intrinsics.checkNotNullParameter((Object)$this$entryNameToPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object[] objectArray = new char[]{'/'};
        List elements = StringsKt.split$default((CharSequence)name, (char[])objectArray, (boolean)false, (int)0, (int)6, null);
        List list = CollectionsKt.drop((Iterable)elements, (int)1);
        String string = (String)CollectionsKt.first((List)elements);
        boolean bl = false;
        String string2 = (String)CollectionsKt.lastOrNull((List)it);
        Collection collection = (Collection)((string2 != null ? ((CharSequence)string2).length() == 0 : false) ? CollectionsKt.dropLast((List)it, (int)1) : it);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new String[0]);
        return PathsKt.Path((String)string, (String[])((String[])Arrays.copyOf(objectArray, objectArray.length)));
    }

    public static final void requireWritable(@NotNull Zip $this$requireWritable) {
        Intrinsics.checkNotNullParameter((Object)$this$requireWritable, (String)"<this>");
        Zip.Mode[] modeArray = new Zip.Mode[]{Zip.Mode.Write, Zip.Mode.Append};
        if (!CollectionsKt.listOf((Object[])modeArray).contains((Object)$this$requireWritable.getMode())) {
            throw new ZipException("Zip is not opened writable");
        }
    }

    public static final void requireReadable(@NotNull Zip $this$requireReadable) {
        Intrinsics.checkNotNullParameter((Object)$this$requireReadable, (String)"<this>");
        Zip.Mode[] modeArray = new Zip.Mode[]{Zip.Mode.Read, Zip.Mode.Append};
        if (!CollectionsKt.listOf((Object[])modeArray).contains((Object)$this$requireReadable.getMode())) {
            throw new ZipException("Zip is not opened readable");
        }
    }

    public static final void requireFile(@NotNull Path $this$requireFile) {
        Intrinsics.checkNotNullParameter((Object)$this$requireFile, (String)"<this>");
        FileMetadata fileMetadata = FileSystemJvmKt.SystemFileSystem.metadataOrNull($this$requireFile);
        if (!(fileMetadata != null ? fileMetadata.isRegularFile() : false)) {
            throw new IllegalArgumentException("File does not exist or is not a regular file: " + $this$requireFile);
        }
    }
}

