/*
 * Decompiled with CFR 0.152.
 */
package de.joerghoh.cq5.jmx.requests;

import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.io.JSONWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSummaryServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 4721202027009891341L;
    private Logger log = LoggerFactory.getLogger(RequestSummaryServlet.class);
    private static final String MBEANFILTER = "de.joerghoh.cq5.jmx.requests.mime:type=*";

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        try {
            JSONWriter result = new JSONWriter((Writer)response.getWriter()).array();
            ObjectName query = new ObjectName(MBEANFILTER);
            Set<ObjectName> mbeans = server.queryNames(query, null);
            for (ObjectName mbean : mbeans) {
                String mbeanName = mbean.toString();
                String requestCounter = String.valueOf(server.getAttribute(mbean, "RequestCounter"));
                String totalDuration = String.valueOf(server.getAttribute(mbean, "TotalRequestDuration"));
                String mimeType = (String)server.getAttribute(mbean, "MimeType");
                result.object().key("MbeanName").value((Object)mbeanName).key("RequestCounter").value((Object)requestCounter).key("TotalRequestDuration").value((Object)totalDuration).key("MimeType").value((Object)mimeType).endObject();
            }
            result.endArray();
        }
        catch (Exception e) {
            this.log.error("Cannot query mbeans", (Throwable)e);
        }
    }
}

