/*
 * Decompiled with CFR 0.152.
 */
package de.joerghoh.cq5.jmx.requests;

import com.day.cq.wcm.api.Page;
import de.joerghoh.cq5.jmx.requests.RequestInformationImpl;
import de.joerghoh.cq5.jmx.requests.RequestInformationMBean;
import java.io.IOException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestFilter
implements Filter {
    private static String MBEAN_PREFIX = "de.joerghoh.cq5.jmx.requests";
    private Logger log = LoggerFactory.getLogger(RequestFilter.class);
    private Map<String, ServiceRegistration> services = new HashMap<String, ServiceRegistration>();
    private BundleContext bundleContext;
    private boolean shutdownInProgress = false;

    protected void activate(ComponentContext ctx) {
        this.bundleContext = ctx.getBundleContext();
        this.shutdownInProgress = false;
    }

    protected void deactivate() {
        this.shutdownInProgress = true;
        for (ServiceRegistration sr : this.services.values()) {
            sr.unregister();
        }
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RequestInformationImpl rii = null;
        if (!this.shutdownInProgress) {
            ServiceRegistration reg;
            Object o;
            String designator;
            SlingHttpServletRequest req = (SlingHttpServletRequest)request;
            Resource r = req.getResource();
            String contentType = req.getResponseContentType();
            Page p = (Page)r.adaptTo(Page.class);
            String templatePath = "";
            if (p != null && p.getTemplate() != null) {
                templatePath = p.getTemplate().getPath();
            }
            if (!this.services.containsKey(designator = this.buildMBeanName(contentType, templatePath))) {
                this.registerReportingService(designator, contentType);
            }
            if ((o = this.bundleContext.getService((reg = this.services.get(designator)).getReference())) instanceof RequestInformationImpl) {
                rii = (RequestInformationImpl)o;
            } else {
                this.log.error("Something went wrong with the retrieval of the service object for meban " + designator);
                rii = null;
            }
        }
        long t1 = System.currentTimeMillis();
        chain.doFilter(request, response);
        long t2 = System.currentTimeMillis();
        if (!this.shutdownInProgress && rii != null) {
            rii.update(t2 - t1);
        }
    }

    private String buildMBeanName(String mimetype, String templatePath) {
        if (templatePath.equals("")) {
            return MBEAN_PREFIX + ".mime:type=" + mimetype;
        }
        return MBEAN_PREFIX + ".template:template=" + templatePath;
    }

    private synchronized ServiceRegistration registerReportingService(String mbeanName, String mimeType) {
        if (!this.services.containsKey(mbeanName)) {
            RequestInformationImpl rii = new RequestInformationImpl(mimeType);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("jmx.objectname", mbeanName);
            this.log.debug("Registering mbean for " + mbeanName);
            ServiceRegistration reg = this.bundleContext.registerService(RequestInformationMBean.class.getName(), (Object)rii, props);
            this.services.put(mbeanName, reg);
            return reg;
        }
        return null;
    }
}

