/*
 * Decompiled with CFR 0.152.
 */
package de.joerghoh.cq5.jmx.bundles;

import de.joerghoh.cq5.jmx.bundles.BundleStatusMBean;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

public class BundleStatusImpl
implements BundleStatusMBean {
    private BundleContext bctx;

    public int getActiveBundles() {
        Bundle[] bundles = this.bctx.getBundles();
        int activeBundleCount = 0;
        for (Bundle b : bundles) {
            boolean isActive;
            Dictionary headers = b.getHeaders();
            boolean isFragment = headers.get("Fragment-Host") != null;
            boolean bl = isActive = b.getState() == 32;
            if (isFragment || !isActive) continue;
            ++activeBundleCount;
        }
        return activeBundleCount;
    }

    protected void activate(ComponentContext ctx) {
        this.bctx = ctx.getBundleContext();
    }

    public int getFragmentBundles() {
        Bundle[] bundles = this.bctx.getBundles();
        int fragmentBundleCount = 0;
        for (Bundle b : bundles) {
            boolean isFragment;
            Dictionary headers = b.getHeaders();
            boolean bl = isFragment = headers.get("Fragment-Host") != null;
            if (!isFragment) continue;
            ++fragmentBundleCount;
        }
        return fragmentBundleCount;
    }

    public int getInstalledBundles() {
        Bundle[] bundles = this.bctx.getBundles();
        int installedBundleCount = 0;
        for (Bundle b : bundles) {
            boolean isInstalled;
            boolean bl = isInstalled = b.getState() == 2;
            if (!isInstalled) continue;
            ++installedBundleCount;
        }
        return installedBundleCount;
    }

    public int getResolvedBundles() {
        Bundle[] bundles = this.bctx.getBundles();
        int resolvedBundleCount = 0;
        for (Bundle b : bundles) {
            boolean isFragment;
            Dictionary headers = b.getHeaders();
            boolean isResolved = b.getState() == 4;
            boolean bl = isFragment = headers.get("Fragment-Host") != null;
            if (!isResolved || isFragment) continue;
            ++resolvedBundleCount;
        }
        return resolvedBundleCount;
    }
}

