/*
 * Decompiled with CFR 0.152.
 */
package de.joerghoh.cq5.healthcheck.impl.providers;

import de.joerghoh.cq5.healthcheck.Status;
import de.joerghoh.cq5.healthcheck.StatusCode;
import de.joerghoh.cq5.healthcheck.StatusProvider;
import java.lang.management.ManagementFactory;
import java.util.Dictionary;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanStatusProvider
implements StatusProvider {
    private static final Logger log = LoggerFactory.getLogger(MBeanStatusProvider.class);
    private MBeanServer server = ManagementFactory.getPlatformMBeanServer();
    private static String MBEAN_NAME = "mbean.name";
    private String mbeanName;
    private static String MBEAN_PROPERTY = "mbean.property";
    private String[] properties;
    private static String MBEAN_PROVIDER_HINT = "mbean.providerHint";
    private String providerHint;
    private String providerName;
    private ObjectName mbean;
    private String statusMessage = "";

    public Status getStatus() {
        this.mbean = this.buildObjectName(this.mbeanName);
        if (this.mbean != null && this.mbeanExists(this.mbean)) {
            StatusCode status = this.calculateStatus();
            return new Status(status, this.statusMessage, this.providerName);
        }
        log.info("Cannot resolve mbean " + this.mbeanName);
        return new Status(StatusCode.UNKNOWN, "cannot find mbean", this.providerName);
    }

    protected void activate(ComponentContext ctx) throws RepositoryException {
        Dictionary props = ctx.getProperties();
        this.mbeanName = PropertiesUtil.toString(props.get(MBEAN_NAME), null);
        this.properties = PropertiesUtil.toStringArray(props.get(MBEAN_PROPERTY));
        this.providerHint = PropertiesUtil.toString(props.get(MBEAN_PROVIDER_HINT), null);
        this.mbean = this.buildObjectName(this.mbeanName);
        if (this.mbean != null && this.mbeanExists(this.mbean)) {
            log.info("Instantiate healtcheck for MBean {}", (Object)this.mbeanName);
        } else {
            log.warn("Cannot instantiate healthcheck for MBean {}", (Object)this.mbeanName);
        }
        this.providerName = this.mbeanName;
        if (this.providerHint != null) {
            this.providerName = this.providerName + " (" + this.providerHint + ")";
        }
    }

    protected void deactivate() {
    }

    private StatusCode calculateStatus() {
        StatusCode accumulatedStatus = StatusCode.OK;
        this.statusMessage = "";
        for (String property : this.properties) {
            String key = new StringBuffer(property).reverse().toString();
            String[] split = key.split("\\.", 4);
            if (split.length != 4) continue;
            String comparisonAttributeName = new StringBuffer(split[3]).reverse().toString();
            String comparisonLevel = new StringBuffer(split[2]).reverse().toString();
            StatusCode statusCode = StatusCode.OK;
            if (comparisonLevel.equalsIgnoreCase("warn")) {
                statusCode = StatusCode.WARN;
            } else if (comparisonLevel.equalsIgnoreCase("critical")) {
                statusCode = StatusCode.CRITICAL;
            } else {
                log.warn("Ignoring property (invalid level): " + property);
                continue;
            }
            String comparisonOperation = new StringBuffer(split[1]).reverse().toString();
            String comparisonValue = new StringBuffer(split[0]).reverse().toString();
            log.debug("compare {} and {}", (Object)property, (Object)comparisonValue);
            Object jmxValueObj = this.getAttributeValue(comparisonAttributeName);
            if (jmxValueObj == null) {
                log.warn("Ignoring property " + property + " (no such JMX attribute " + comparisonAttributeName + ")");
                this.statusMessage = "Cannot resolve property or MBean";
                return StatusCode.WARN;
            }
            log.debug("jmx value = {}", jmxValueObj);
            boolean match = false;
            try {
                match = this.compareAttributeValue(comparisonOperation, comparisonValue, jmxValueObj);
            }
            catch (RuntimeException e) {
                log.info("Ignoring property (invalid value type): " + property);
                continue;
            }
            if (match) {
                if (this.statusMessage.length() > 0) {
                    this.statusMessage = this.statusMessage + ", ";
                }
                this.statusMessage = this.statusMessage + comparisonAttributeName + " = " + (jmxValueObj.getClass().isArray() ? ArrayUtils.toString((Object)jmxValueObj) : jmxValueObj.toString());
            }
            if (!match || statusCode.compareTo((Enum)accumulatedStatus) <= 0) continue;
            accumulatedStatus = statusCode;
        }
        return accumulatedStatus;
    }

    private Object getAttributeValue(String attributeName) {
        try {
            return this.server.getAttribute(this.mbean, attributeName);
        }
        catch (Exception e) {
            log.warn("Cannot read attribute " + attributeName + " from MBean " + this.mbean);
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean compareAttributeValue(String comparisonOperation, String comparisonValue, Object jmxValueObj) {
        boolean match = false;
        if (jmxValueObj instanceof Long) {
            long jmxLongValue = Long.parseLong(jmxValueObj.toString());
            long comparisonLongValue = NumberUtils.createLong((String)comparisonValue);
            if (comparisonOperation.equals(">")) {
                if (jmxLongValue <= comparisonLongValue) return false;
                return true;
            }
            if (comparisonOperation.equals("==")) {
                if (jmxLongValue != comparisonLongValue) return false;
                return true;
            }
            if (comparisonOperation.equals("!=")) {
                if (jmxLongValue == comparisonLongValue) return false;
                return true;
            }
            if (comparisonOperation.equals("<")) {
                if (jmxLongValue >= comparisonLongValue) return false;
                return true;
            }
            log.warn("Can not compare long values {} and {}", (Object)jmxLongValue, (Object)comparisonLongValue);
            throw new RuntimeException();
        }
        if (jmxValueObj instanceof Integer) {
            int jmxIntValue = Integer.parseInt(jmxValueObj.toString());
            int comparisonIntValue = NumberUtils.createInteger((String)comparisonValue);
            if (comparisonOperation.equals(">")) {
                if (jmxIntValue <= comparisonIntValue) return false;
                return true;
            }
            if (comparisonOperation.equals("==")) {
                if (jmxIntValue != comparisonIntValue) return false;
                return true;
            }
            if (comparisonOperation.equals("!=")) {
                if (jmxIntValue == comparisonIntValue) return false;
                return true;
            }
            if (comparisonOperation.equals("<")) {
                if (jmxIntValue >= comparisonIntValue) return false;
                return true;
            }
            log.warn("Can not compare int values {} and {}", (Object)jmxIntValue, (Object)comparisonIntValue);
            throw new RuntimeException();
        }
        if (jmxValueObj instanceof long[]) {
            long[] jmxLongArrayValue = (long[])jmxValueObj;
            long comparisonLongValue = NumberUtils.createLong((String)comparisonValue);
            if (comparisonOperation.equals(">")) {
                if (NumberUtils.max((long[])jmxLongArrayValue) <= comparisonLongValue) return false;
                return true;
            }
            if (comparisonOperation.equals("==")) {
                return ArrayUtils.contains((long[])jmxLongArrayValue, (long)comparisonLongValue);
            }
            if (comparisonOperation.equals("<")) {
                if (NumberUtils.min((long[])jmxLongArrayValue) >= comparisonLongValue) return false;
                return true;
            }
            log.warn("Can not compare long array values {} and {}", (Object)jmxLongArrayValue, (Object)comparisonLongValue);
            throw new RuntimeException();
        }
        if (jmxValueObj instanceof String) {
            log.info("type comparison: string");
            String jmxStringValue = jmxValueObj.toString();
            if (comparisonOperation.equals("equals")) {
                return comparisonValue.equals(jmxStringValue);
            }
            if (comparisonOperation.equals("notequals")) {
                if (comparisonValue.equals(jmxStringValue)) return false;
                return true;
            }
            log.warn("Can not compare String values {} and {}", (Object)jmxStringValue, (Object)comparisonValue);
            throw new RuntimeException();
        }
        if (jmxValueObj instanceof Boolean) {
            boolean jmxBooleanValue = (Boolean)jmxValueObj;
            boolean comparisonBooleanValue = Boolean.parseBoolean(comparisonValue);
            if (comparisonOperation.equals("equals")) {
                if (comparisonBooleanValue != jmxBooleanValue) return false;
                return true;
            }
            if (comparisonOperation.equals("==")) {
                if (comparisonBooleanValue != jmxBooleanValue) return false;
                return true;
            }
            if (comparisonOperation.equals("notequals")) {
                if (comparisonBooleanValue == jmxBooleanValue) return false;
                return true;
            }
            log.warn("Can not compare boolean values {} and {}", (Object)jmxBooleanValue, (Object)comparisonBooleanValue);
            throw new RuntimeException();
        }
        log.warn("Can not compare jmx attribute value {} with {}", jmxValueObj, (Object)comparisonValue);
        log.warn("jmxValueObj type = " + jmxValueObj.getClass().getName());
        throw new RuntimeException();
    }

    private ObjectName buildObjectName(String name) {
        ObjectName mbean = null;
        try {
            mbean = new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            log.error("Cannot create ObjectName " + name, (Throwable)e);
        }
        catch (NullPointerException e) {
            log.error("Cannot create ObjectName " + name, (Throwable)e);
        }
        return mbean;
    }

    private boolean mbeanExists(ObjectName mbean) {
        Set<ObjectName> beans = this.server.queryNames(mbean, null);
        return beans.size() == 1;
    }
}

