/*
 * Decompiled with CFR 0.152.
 */
package de.joerghoh.cq5.healthcheck.impl;

import com.day.cq.jcrclustersupport.ClusterAware;
import de.joerghoh.cq5.healthcheck.StatusCode;
import de.joerghoh.cq5.healthcheck.StatusService;
import java.io.IOException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.jcr.api.SlingRepository;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadbalancerStatus
extends SlingSafeMethodsServlet
implements ClusterAware {
    private StatusService statusService;
    private SlingRepository repository;
    private static final String DEFAULT_LB_STRATEGY = "ActivePassive";
    private static final String PROPERTY_LB_STRATEGY = "strategy";
    private boolean iAmMaster = false;
    private String loadbalancerStrategy;
    private Logger log = LoggerFactory.getLogger(LoadbalancerStatus.class);
    private static final long serialVersionUID = -8012558085365805331L;

    public void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        try {
            StatusCode status = this.statusService.getStatus().getStatus();
            boolean allServicesOK = status == StatusCode.OK;
            boolean statusOK = false;
            if (this.loadbalancerStrategy.equals(DEFAULT_LB_STRATEGY)) {
                statusOK = this.iAmMaster && allServicesOK;
            } else if (this.loadbalancerStrategy.equals("ActiveActive")) {
                statusOK = allServicesOK;
            } else {
                statusOK = false;
                this.log.error("Invalid loadbalancer strategy set: " + this.loadbalancerStrategy);
            }
            response.setContentType("text/html");
            if (statusOK) {
                response.setStatus(200);
                response.getOutputStream().print(StatusCode.OK.toString());
            } else {
                response.setStatus(500);
                response.getOutputStream().print(StatusCode.WARN.toString());
            }
            response.getOutputStream().flush();
        }
        catch (IOException e) {
            this.log.warn("Cannot write to output: " + e.getMessage());
        }
    }

    public void bindRepository(String repositoryId, String clusterId, boolean isMaster) {
        this.iAmMaster = isMaster;
    }

    public void unbindRepository() {
        this.log.warn("Repository is unbound, this should not happen!");
    }

    public void Activate(ComponentContext ctx) {
        this.loadbalancerStrategy = PropertiesUtil.toString(ctx.getProperties().get(PROPERTY_LB_STRATEGY), (String)DEFAULT_LB_STRATEGY);
        this.log.info("Using loadbalancer strategy " + this.loadbalancerStrategy);
        String v = this.repository.getDescriptor("crx.cluster.master");
        this.iAmMaster = v == null || Boolean.parseBoolean(v);
    }

    protected void bindStatusService(StatusService statusService) {
        this.statusService = statusService;
    }

    protected void unbindStatusService(StatusService statusService) {
        if (this.statusService == statusService) {
            this.statusService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

