/*
 * Decompiled with CFR 0.152.
 */
package de.joerghoh.cq5.healthcheck.impl;

import de.joerghoh.cq5.healthcheck.Status;
import de.joerghoh.cq5.healthcheck.StatusCode;
import de.joerghoh.cq5.healthcheck.StatusProvider;
import de.joerghoh.cq5.healthcheck.StatusService;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthStatusServiceImpl
implements StatusService {
    private List<StatusProvider> providers = new ArrayList<StatusProvider>();
    private final Logger log = LoggerFactory.getLogger(HealthStatusServiceImpl.class);
    private static int DEFAULT_NUMBER_BUNDLES = 10;
    private static String BUNDLE_NUMBER_THRESHOLD_PROP = "bundle.threshold";
    private int bundleNumberThreshold;

    public Status getStatus() {
        StatusCode finalStatus = StatusCode.OK;
        ArrayList<Status> results = new ArrayList<Status>();
        String message = "";
        for (StatusProvider p : this.providers) {
            Status s = p.getStatus();
            if (s.getStatus().compareTo((Enum)finalStatus) > 0) {
                finalStatus = s.getStatus();
            }
            results.add(s);
        }
        if (results.size() < this.bundleNumberThreshold) {
            finalStatus = StatusCode.CRITICAL;
            message = "Only " + results.size() + " out of configured " + this.bundleNumberThreshold + " monitoring services available";
            this.log.warn(message);
        }
        this.log.info("Processed " + results.size() + " providers");
        return new Status(finalStatus, message, results);
    }

    protected void bindHealthStatusProvider(StatusProvider provider) {
        this.providers.add(provider);
    }

    protected void unbindHealthStatusProvider(StatusProvider provider) {
        this.providers.remove(provider);
    }

    protected void activate(ComponentContext context) {
        Dictionary properties = context.getProperties();
        this.bundleNumberThreshold = PropertiesUtil.toInteger(properties.get(BUNDLE_NUMBER_THRESHOLD_PROP), (int)DEFAULT_NUMBER_BUNDLES);
    }
}

